/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.james.ExtraProperties;
import org.apache.james.FakeSearchMailboxModule;
import org.apache.james.GuiceJamesServer;
import org.apache.james.JamesServerMain;
import org.apache.james.MemoryJamesConfiguration;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.jmap.memory.pushsubscription.MemoryPushSubscriptionModule;
import org.apache.james.jwt.JwtConfiguration;
import org.apache.james.modules.BlobExportMechanismModule;
import org.apache.james.modules.BlobMemoryModule;
import org.apache.james.modules.MailboxModule;
import org.apache.james.modules.MailetProcessingModule;
import org.apache.james.modules.data.MemoryDataJmapModule;
import org.apache.james.modules.data.MemoryDataModule;
import org.apache.james.modules.data.MemoryUsersRepositoryModule;
import org.apache.james.modules.eventstore.MemoryEventStoreModule;
import org.apache.james.modules.mailbox.MemoryMailboxModule;
import org.apache.james.modules.protocols.IMAPServerModule;
import org.apache.james.modules.protocols.JMAPServerModule;
import org.apache.james.modules.protocols.JmapEventBusModule;
import org.apache.james.modules.protocols.LMTPServerModule;
import org.apache.james.modules.protocols.ManageSieveServerModule;
import org.apache.james.modules.protocols.POP3ServerModule;
import org.apache.james.modules.protocols.ProtocolHandlerModule;
import org.apache.james.modules.protocols.SMTPServerModule;
import org.apache.james.modules.queue.memory.MemoryMailQueueModule;
import org.apache.james.modules.server.DKIMMailetModule;
import org.apache.james.modules.server.DLPRoutesModule;
import org.apache.james.modules.server.DataRoutesModules;
import org.apache.james.modules.server.JMXServerModule;
import org.apache.james.modules.server.JmapTasksModule;
import org.apache.james.modules.server.MailQueueRoutesModule;
import org.apache.james.modules.server.MailRepositoriesRoutesModule;
import org.apache.james.modules.server.MailboxRoutesModule;
import org.apache.james.modules.server.MailboxesExportRoutesModule;
import org.apache.james.modules.server.MailetContainerModule;
import org.apache.james.modules.server.NoJwtModule;
import org.apache.james.modules.server.RawPostDequeueDecoratorModule;
import org.apache.james.modules.server.SieveRoutesModule;
import org.apache.james.modules.server.TaskManagerModule;
import org.apache.james.modules.server.VacationRoutesModule;
import org.apache.james.modules.server.WebAdminServerModule;
import org.apache.james.modules.spamassassin.SpamAssassinListenerModule;
import org.apache.james.modules.vault.DeletedMessageVaultModule;
import org.apache.james.modules.vault.DeletedMessageVaultRoutesModule;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.webadmin.WebAdminConfiguration;
import org.apache.james.webadmin.authentication.AuthenticationFilter;
import org.apache.james.webadmin.authentication.NoAuthenticationFilter;

public class MemoryJamesServerMain
implements JamesServerMain {
    public static final Module WEBADMIN = Modules.combine((Module[])new Module[]{new WebAdminServerModule(), new DataRoutesModules(), new VacationRoutesModule(), new DeletedMessageVaultRoutesModule(), new DLPRoutesModule(), new MailboxesExportRoutesModule(), new MailboxRoutesModule(), new MailQueueRoutesModule(), new MailRepositoriesRoutesModule(), new SieveRoutesModule()});
    public static final JwtConfiguration NO_JWT_CONFIGURATION = new JwtConfiguration((List)ImmutableList.of());
    public static final Module WEBADMIN_NO_AUTH_MODULE = Modules.combine((Module[])new Module[]{binder -> binder.bind(JwtConfiguration.class).toInstance((Object)NO_JWT_CONFIGURATION), binder -> binder.bind(AuthenticationFilter.class).to(NoAuthenticationFilter.class), binder -> binder.bind(WebAdminConfiguration.class).toInstance((Object)WebAdminConfiguration.TEST_CONFIGURATION)});
    public static final Module WEBADMIN_TESTING = Modules.override((Module[])new Module[]{WEBADMIN}).with(new Module[]{WEBADMIN_NO_AUTH_MODULE, new NoJwtModule()});
    public static final Module PROTOCOLS = Modules.combine((Module[])new Module[]{new IMAPServerModule(), new LMTPServerModule(), new ManageSieveServerModule(), new POP3ServerModule(), new ProtocolHandlerModule(), new SMTPServerModule(), new SpamAssassinListenerModule()});
    public static final Module JMAP = Modules.combine((Module[])new Module[]{new JmapEventBusModule(), new JmapTasksModule(), new MemoryDataJmapModule(), new MemoryPushSubscriptionModule(), new JMAPServerModule()});
    public static final Module IN_MEMORY_SERVER_MODULE = Modules.combine((Module[])new Module[]{new MailetProcessingModule(), new BlobMemoryModule(), new DeletedMessageVaultModule(), new BlobExportMechanismModule(), new MailboxModule(), new MemoryDataModule(), new MemoryEventStoreModule(), new MemoryMailboxModule(), new MemoryMailQueueModule(), new TaskManagerModule()});
    public static final Module SMTP_ONLY_MODULE = Modules.combine((Module[])new Module[]{IN_MEMORY_SERVER_MODULE, new ProtocolHandlerModule(), new SMTPServerModule(), new RawPostDequeueDecoratorModule(), binder -> binder.bind(MailetContainerModule.DefaultProcessorsConfigurationSupplier.class).toInstance(BaseHierarchicalConfiguration::new)});
    public static final Module SMTP_AND_IMAP_MODULE = Modules.combine((Module[])new Module[]{SMTP_ONLY_MODULE, new IMAPServerModule()});
    public static final Module IN_MEMORY_SERVER_AGGREGATE_MODULE = Modules.combine((Module[])new Module[]{IN_MEMORY_SERVER_MODULE, PROTOCOLS, JMAP, WEBADMIN, new DKIMMailetModule()});

    public static void main(String[] args) throws Exception {
        ExtraProperties.initialize();
        MemoryJamesConfiguration configuration = MemoryJamesConfiguration.builder().useWorkingDirectoryEnvProperty().build();
        LOGGER.info("Loading configuration {}", (Object)configuration.toString());
        GuiceJamesServer server = MemoryJamesServerMain.createServer(configuration).combineWith(new Module[]{new FakeSearchMailboxModule(), new JMXServerModule()});
        JamesServerMain.main((GuiceJamesServer)server);
    }

    public static GuiceJamesServer createServer(MemoryJamesConfiguration configuration) {
        return GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{IN_MEMORY_SERVER_AGGREGATE_MODULE}).combineWith((Collection)new UsersRepositoryModuleChooser((Module)new MemoryUsersRepositoryModule()).chooseModules(configuration.getUsersRepositoryImplementation()));
    }
}

