/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.uptrust.proxy.base.handler.IComplexMailHandler;
import net.savignano.uptrust.proxy.base.handler.outgoing.OutgoingMailHandler;
import net.savignano.uptrust.proxy.base.handler.outgoing.OutgoingMailHandlerBuilder;
import net.savignano.uptrust.service.IUptrustService;
import net.savignano.uptrust.service.cryptography.IDecryptionService;
import org.apache.commons.configuration2.ImmutableConfiguration;

public class SmtpMailHandlerFactory
implements Provider<OutgoingMailHandler> {
    private static final String OUTGOING_MAIL_HANDLER_KEY = "outgoingMail";
    private final IUptrustService uptrustService;

    @Inject
    public SmtpMailHandlerFactory(IUptrustService uptrustService) {
        this.uptrustService = uptrustService;
    }

    public OutgoingMailHandler get() {
        return this.buildOutgoingMailHandler(this.uptrustService);
    }

    public IComplexMailHandler createOutgoingMailHandler() {
        return this.buildOutgoingMailHandler(this.uptrustService);
    }

    private OutgoingMailHandler buildOutgoingMailHandler(IUptrustService service) {
        return OutgoingMailHandlerBuilder.from((ImmutableConfiguration)service.getConfig().configurationAt(OUTGOING_MAIL_HANDLER_KEY)).checkLicenseWith(null).encryptWith(service.getEncryptionService()).detectCrypto(this.getDetectCryptoFunc(service)).detectEncryption(this.getDetectEncPred(service.getDecryptionService())).build();
    }

    private Function<MimeMessage, ECryptographyType> getDetectCryptoFunc(IUptrustService service) {
        return arg_0 -> ((IUptrustService)service).determineCryptography(arg_0);
    }

    private Predicate<MimeMessage> getDetectEncPred(IDecryptionService service) {
        return service == null ? msg -> false : arg_0 -> ((IDecryptionService)service).isEncrypted(arg_0);
    }
}

