/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.netty;

import net.savignano.uptrust.proxy.base.proxy.IProxy;
import net.savignano.uptrust.proxy.smtp.proxy.SmtpProxy;
import net.savignano.uptrust.proxy.smtp.proxy.SmtpProxyConfiguration;
import net.savignano.uptrust.proxy.smtp.proxy.SmtpProxyFactory;
import net.savignano.uptrust.proxy.smtp.request.ProxyRequest;
import net.savignano.uptrust.proxy.smtp.response.ProxyResponse;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.netty.BasicChannelUpstreamHandler;
import org.apache.james.protocols.netty.ProtocolMDCContextFactory;
import org.apache.james.protocols.smtp.core.SMTPMDCContextFactory;
import org.apache.james.smtpserver.ExtendedSMTPSession;
import org.apache.james.smtpserver.SMTPConstants;
import org.apache.james.smtpserver.netty.SmtpMetrics;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class SMTPChannelUpstreamHandler
extends BasicChannelUpstreamHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMTPChannelUpstreamHandler.class);
    private final SmtpMetrics smtpMetrics;
    private SmtpProxyConfiguration proxyConfiguration;

    public SMTPChannelUpstreamHandler(Protocol protocol, Encryption encryption, SmtpMetrics smtpMetrics) {
        super((ProtocolMDCContextFactory)new SMTPMDCContextFactory(), protocol, encryption);
        this.smtpMetrics = smtpMetrics;
    }

    public SMTPChannelUpstreamHandler(Protocol protocol, SmtpMetrics smtpMetrics) {
        super((ProtocolMDCContextFactory)new SMTPMDCContextFactory(), protocol);
        this.smtpMetrics = smtpMetrics;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.getSession(ctx).setProxy((IProxy)this.createProxy());
        super.channelConnected(ctx, e);
        this.smtpMetrics.getConnectionMetric().increment();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
        this.smtpMetrics.getCommandsMetric().increment();
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelDisconnected(ctx, e);
        this.smtpMetrics.getConnectionMetric().decrement();
    }

    protected void cleanup(ChannelHandlerContext ctx) {
        ExtendedSMTPSession smtpSession = this.getSession(ctx);
        if (smtpSession != null) {
            smtpSession.getAttachment(SMTPConstants.MAIL, ProtocolSession.State.Transaction).ifPresent(LifecycleUtil::dispose);
            smtpSession.getAttachment(SMTPConstants.DATA_MIMEMESSAGE_STREAMSOURCE, ProtocolSession.State.Transaction).ifPresent(LifecycleUtil::dispose);
            this.closeProxy(this.getProxy(smtpSession));
        }
        super.cleanup(ctx);
    }

    public SmtpProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public void setProxyConfiguration(SmtpProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    private ExtendedSMTPSession getSession(ChannelHandlerContext ctx) {
        return (ExtendedSMTPSession)((Object)ctx.getAttachment());
    }

    private IProxy<ProxyRequest, ProxyResponse> getProxy(ExtendedSMTPSession session) {
        return session.getProxy();
    }

    private SmtpProxy createProxy() {
        return SmtpProxyFactory.create((SmtpProxyConfiguration)this.getProxyConfiguration());
    }

    private void closeProxy(IProxy<?, ?> proxy) {
        if (proxy == null) {
            return;
        }
        LOGGER.info("Closing connection to mail server at: {}", (Object)proxy.getAddress());
        proxy.close();
    }
}

