/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.process;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.text.RandomStringGenerator;
import org.apache.james.core.Username;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.protocols.api.CommandDetectionSession;
import org.apache.james.protocols.api.OidcSASLConfiguration;

public interface ImapSession
extends CommandDetectionSession {
    public static final String MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY = "org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY";

    public SessionId sessionId();

    public void logout();

    public ImapSessionState getState();

    public void authenticated();

    public void selected(SelectedMailbox var1);

    public void deselect();

    public SelectedMailbox getSelected();

    public Object getAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public boolean startTLS();

    public boolean isTLSActive();

    public boolean supportStartTLS();

    public boolean enforceStartTLS();

    public boolean isCompressionActive();

    public boolean isCompressionSupported();

    public boolean startCompression();

    public void pushLineHandler(ImapLineHandler var1);

    public void popLineHandler();

    public boolean supportMultipleNamespaces();

    public boolean isSSLRequired();

    public boolean isPlainAuthEnabled();

    public boolean supportsOAuth();

    public Optional<OidcSASLConfiguration> oidcSaslConfiguration();

    default public void setMailboxSession(MailboxSession mailboxSession) {
        this.setAttribute(MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY, mailboxSession);
    }

    default public MailboxSession getMailboxSession() {
        return (MailboxSession)this.getAttribute(MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY);
    }

    default public Username getUserName() {
        return Optional.ofNullable(this.getMailboxSession()).map(MailboxSession::getUser).orElse(null);
    }

    default public boolean isPlainAuthDisallowed() {
        return !this.isPlainAuthEnabled() || this.isAuthenticatingNonEncryptedWhenRequiredSSL();
    }

    default public boolean isAuthenticatingNonEncryptedWhenRequiredSSL() {
        return this.isSSLRequired() && !this.isTLSActive();
    }

    public static class SessionId {
        private static final RandomStringGenerator RANDOM_STRING_GENERATOR = new RandomStringGenerator.Builder().withinRange(97, 122).build();
        private static final int LENGTH = 12;
        private final String value;

        public static SessionId generate() {
            return new SessionId("SID-" + RANDOM_STRING_GENERATOR.generate(12));
        }

        private SessionId(String value) {
            this.value = value;
        }

        public String asString() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof SessionId) {
                SessionId sessionId = (SessionId)o;
                return Objects.equals(this.value, sessionId.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.asString();
        }
    }
}

