/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.Flags;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.decode.DecodingException;

public final class DecoderUtils {
    private static final int ASCII_ZERO = 48;
    private static final int JAN_BIT = 1;
    private static final int FEB_BIT = 2;
    private static final int MAR_BIT = 4;
    private static final int APR_BIT = 8;
    private static final int MAY_BIT = 16;
    private static final int JUN_BIT = 32;
    private static final int JUL_BIT = 64;
    private static final int AUG_BIT = 128;
    private static final int SEP_BIT = 256;
    private static final int OCT_BIT = 512;
    private static final int NOV_BIT = 1024;
    private static final int DEC_BIT = 2048;
    private static final int ALL_MONTH_BITS = 4095;

    public static void setFlag(String flagString, Flags flags) throws DecodingException {
        if (flagString.equalsIgnoreCase("\\ANSWERED")) {
            flags.add(Flags.Flag.ANSWERED);
        } else if (flagString.equalsIgnoreCase("\\DELETED")) {
            flags.add(Flags.Flag.DELETED);
        } else if (flagString.equalsIgnoreCase("\\DRAFT")) {
            flags.add(Flags.Flag.DRAFT);
        } else if (flagString.equalsIgnoreCase("\\FLAGGED")) {
            flags.add(Flags.Flag.FLAGGED);
        } else if (flagString.equalsIgnoreCase("\\SEEN")) {
            flags.add(Flags.Flag.SEEN);
        } else {
            if (flagString.equalsIgnoreCase("\\RECENT")) {
                throw new DecodingException(HumanReadableText.INVALID_SYSTEM_FLAG, "\\Recent flag is now allowed to set.");
            }
            flags.add(flagString);
        }
    }

    public static LocalDateTime decodeDateTime(CharSequence chars) throws DecodingException {
        if (DecoderUtils.isDateTime(chars)) {
            char dayHigh = chars.charAt(0);
            char dayLow = chars.charAt(1);
            int day = DecoderUtils.decodeFixedDay(dayHigh, dayLow);
            char monthFirstChar = chars.charAt(3);
            char monthSecondChar = chars.charAt(4);
            char monthThirdChar = chars.charAt(5);
            int month = DecoderUtils.decodeMonth(monthFirstChar, monthSecondChar, monthThirdChar);
            char milleniumChar = chars.charAt(7);
            char centuryChar = chars.charAt(8);
            char decadeChar = chars.charAt(9);
            char yearChar = chars.charAt(10);
            int year = DecoderUtils.decodeYear(milleniumChar, centuryChar, decadeChar, yearChar);
            char zoneDeterminent = chars.charAt(21);
            char zoneDigitOne = chars.charAt(22);
            char zoneDigitTwo = chars.charAt(23);
            char zoneDigitThree = chars.charAt(24);
            char zoneDigitFour = chars.charAt(25);
            int offset = DecoderUtils.decodeZone(zoneDeterminent, zoneDigitOne, zoneDigitTwo, zoneDigitThree, zoneDigitFour);
            char hourHigh = chars.charAt(12);
            char hourLow = chars.charAt(13);
            int hour = DecoderUtils.applyHourOffset(offset, DecoderUtils.decodeNumber(hourHigh, hourLow));
            char minuteHigh = chars.charAt(15);
            char minuteLow = chars.charAt(16);
            int minute = DecoderUtils.applyMinuteOffset(offset, DecoderUtils.decodeNumber(minuteHigh, minuteLow));
            char secondHigh = chars.charAt(18);
            char secondLow = chars.charAt(19);
            int second = DecoderUtils.decodeNumber(secondHigh, secondLow);
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"), Locale.US);
            calendar.clear();
            calendar.set(year, month, day, hour, minute, second);
            return LocalDateTime.ofInstant(calendar.getTime().toInstant(), ZoneId.systemDefault());
        }
        String message = chars == null ? "Expected a date-time but was nothing." : new StringBuffer("Expected a date-time but was ").append(chars.toString()).toString();
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, message);
    }

    private static boolean isDateTime(CharSequence chars) {
        boolean result = chars == null ? false : chars.length() >= 26;
        return result;
    }

    private static int applyMinuteOffset(int offset, int minutes) {
        return minutes - Math.abs(offset) % 100 * (offset == 0 ? 0 : (offset > 0 ? 1 : -1));
    }

    private static int applyHourOffset(int offset, int hours) {
        return hours - offset / 100;
    }

    public static int decodeNumber(char high, char low) throws DecodingException {
        return 10 * DecoderUtils.decodeDigit(high) + DecoderUtils.decodeDigit(low);
    }

    public static int decodeZone(char zoneDeterminent, char zoneDigitOne, char zoneDigitTwo, char zoneDigitThree, char zoneDigitFour) throws DecodingException {
        int sign;
        if (DecoderUtils.isInvalidZone(zoneDeterminent, zoneDigitOne, zoneDigitTwo, zoneDigitThree, zoneDigitFour)) {
            throw DecoderUtils.createTimeZoneException(zoneDeterminent, zoneDigitOne, zoneDigitTwo, zoneDigitThree, zoneDigitFour);
        }
        if (zoneDeterminent == '+') {
            sign = 1;
        } else if (zoneDeterminent == '-') {
            sign = -1;
        } else {
            throw DecoderUtils.createTimeZoneException(zoneDeterminent, zoneDigitOne, zoneDigitTwo, zoneDigitThree, zoneDigitFour);
        }
        return sign * (1000 * DecoderUtils.decodeDigit(zoneDigitOne) + 100 * DecoderUtils.decodeDigit(zoneDigitTwo) + 10 * DecoderUtils.decodeDigit(zoneDigitThree) + DecoderUtils.decodeDigit(zoneDigitFour));
    }

    private static DecodingException createTimeZoneException(char zoneDeterminent, char zoneDigitOne, char zoneDigitTwo, char zoneDigitThree, char zoneDigitFour) {
        return new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Expected time-zone but was " + zoneDeterminent + zoneDigitOne + zoneDigitTwo + zoneDigitThree + zoneDigitFour);
    }

    private static boolean isInvalidZone(char zoneDeterminent, char zoneDigitOne, char zoneDigitTwo, char zoneDigitThree, char zoneDigitFour) {
        boolean result = zoneDeterminent == '+' || zoneDeterminent == '-' ? !DecoderUtils.isSimpleDigit(zoneDigitOne) || !DecoderUtils.isSimpleDigit(zoneDigitTwo) || !DecoderUtils.isSimpleDigit(zoneDigitThree) || !DecoderUtils.isSimpleDigit(zoneDigitFour) : true;
        return result;
    }

    public static boolean isSimpleDigit(char character) {
        return character >= '0' && character <= '9';
    }

    public static int decodeYear(char milleniumChar, char centuryChar, char decadeChar, char yearChar) throws DecodingException {
        return DecoderUtils.decodeDigit(milleniumChar) * 1000 + DecoderUtils.decodeDigit(centuryChar) * 100 + DecoderUtils.decodeDigit(decadeChar) * 10 + DecoderUtils.decodeDigit(yearChar);
    }

    public static int decodeMonth(char monthFirstChar, char monthSecondChar, char monthThirdChar) throws DecodingException {
        int possibleMonths = 4095;
        switch (monthFirstChar) {
            case 'J': 
            case 'j': {
                possibleMonths &= 0x61;
                break;
            }
            case 'F': 
            case 'f': {
                possibleMonths &= 2;
                break;
            }
            case 'M': 
            case 'm': {
                possibleMonths &= 0x14;
                break;
            }
            case 'A': 
            case 'a': {
                possibleMonths &= 0x88;
                break;
            }
            case 'S': 
            case 's': {
                possibleMonths &= 0x100;
                break;
            }
            case 'O': 
            case 'o': {
                possibleMonths &= 0x200;
                break;
            }
            case 'N': 
            case 'n': {
                possibleMonths &= 0x400;
                break;
            }
            case 'D': 
            case 'd': {
                possibleMonths &= 0x800;
                break;
            }
            default: {
                possibleMonths = 0;
            }
        }
        switch (monthSecondChar) {
            case 'A': 
            case 'a': {
                possibleMonths &= 0x15;
                break;
            }
            case 'E': 
            case 'e': {
                possibleMonths &= 0x902;
                break;
            }
            case 'P': 
            case 'p': {
                possibleMonths &= 8;
                break;
            }
            case 'U': 
            case 'u': {
                possibleMonths &= 0xE0;
                break;
            }
            case 'C': 
            case 'c': {
                possibleMonths &= 0x200;
                break;
            }
            case 'O': 
            case 'o': {
                possibleMonths &= 0x400;
                break;
            }
            default: {
                possibleMonths = 0;
            }
        }
        switch (monthThirdChar) {
            case 'N': 
            case 'n': {
                possibleMonths &= 0x21;
                break;
            }
            case 'B': 
            case 'b': {
                possibleMonths &= 2;
                break;
            }
            case 'R': 
            case 'r': {
                possibleMonths &= 0xC;
                break;
            }
            case 'Y': 
            case 'y': {
                possibleMonths &= 0x10;
                break;
            }
            case 'L': 
            case 'l': {
                possibleMonths &= 0x40;
                break;
            }
            case 'G': 
            case 'g': {
                possibleMonths &= 0x80;
                break;
            }
            case 'P': 
            case 'p': {
                possibleMonths &= 0x100;
                break;
            }
            case 'T': 
            case 't': {
                possibleMonths &= 0x200;
                break;
            }
            case 'V': 
            case 'v': {
                possibleMonths &= 0x400;
                break;
            }
            case 'C': 
            case 'c': {
                possibleMonths &= 0x800;
                break;
            }
            default: {
                possibleMonths = 0;
            }
        }
        return switch (possibleMonths) {
            case 1 -> 0;
            case 2 -> 1;
            case 4 -> 2;
            case 8 -> 3;
            case 16 -> 4;
            case 32 -> 5;
            case 64 -> 6;
            case 128 -> 7;
            case 256 -> 8;
            case 512 -> 9;
            case 1024 -> 10;
            case 2048 -> 11;
            default -> throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Expected month name but was " + monthFirstChar + monthSecondChar + monthThirdChar);
        };
    }

    public static int decodeFixedDay(char dayHigh, char dayLow) throws DecodingException {
        int result = DecoderUtils.decodeDigit(dayLow);
        switch (dayHigh) {
            case '0': {
                return result;
            }
            case '1': {
                return result += 10;
            }
            case '2': {
                return result += 20;
            }
            case '3': {
                return result += 30;
            }
            case ' ': {
                return result;
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Expected SP, 0, 1, 2, or 3 but was " + dayHigh);
    }

    public static int decodeDigit(char character) throws DecodingException {
        int result = character - 48;
        if (result < 0 || result > 9) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Expected a digit but was '" + character + "'");
        }
        return result;
    }
}

