/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Flags;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.display.ModifiedUtf7;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.request.DayMonthYear;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SearchResUtil;
import org.apache.james.imap.decode.DecoderUtils;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.message.Literal;
import org.apache.james.mailbox.MessageUid;

public abstract class ImapRequestLineReader {
    private static final int QUOTED_BUFFER_INITIAL_CAPACITY = 64;
    protected boolean nextSeen = false;
    protected char nextChar;

    public static int cap(char next) {
        return next > 90 ? next ^ 0x20 : next;
    }

    public char nextWordChar() throws DecodingException {
        char next = this.nextChar();
        while (next == ' ') {
            this.consume();
            next = this.nextChar();
        }
        if (next == '\r' || next == '\n') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Missing argument.");
        }
        return next;
    }

    public abstract char nextChar() throws DecodingException;

    public void eol() throws DecodingException {
        char next = this.nextChar();
        while (next == ' ') {
            this.consume();
            next = this.nextChar();
        }
        if (next == '\r') {
            this.consume();
            next = this.nextChar();
        }
        if (next != '\n') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Expected end-of-line, found '" + next + "'.");
        }
    }

    public char consume() throws DecodingException {
        char current = this.nextChar();
        this.nextSeen = false;
        this.nextChar = '\u0000';
        return current;
    }

    public abstract Literal read(int var1, boolean var2) throws IOException;

    protected abstract void commandContinuationRequest() throws DecodingException;

    public void consumeLine() throws DecodingException {
        char next = this.nextChar();
        while (next != '\n') {
            this.consume();
            next = this.nextChar();
        }
        this.consume();
    }

    public String line() throws DecodingException {
        StringBuilder builder = new StringBuilder(50);
        char next = this.nextChar();
        while (next != '\n') {
            builder.append(next);
            this.consume();
            next = this.nextChar();
        }
        int index = builder.length() - 1;
        while (index >= 0 && ImapRequestLineReader.isWhitespace(builder.charAt(index))) {
            builder.deleteCharAt(index--);
        }
        return builder.toString();
    }

    public String atom() throws DecodingException {
        return this.consumeWord(new AtomCharValidator(), true);
    }

    public Tag tag() throws DecodingException {
        TagCharValidator validator = new TagCharValidator();
        return new Tag(this.consumeWord(validator));
    }

    public String astring() throws DecodingException {
        return this.astring(null);
    }

    public String astring(Charset charset) throws DecodingException {
        char next = this.nextWordChar();
        switch (next) {
            case '\"': {
                return this.consumeQuoted(charset);
            }
            case '{': {
                return this.consumeLiteral(charset);
            }
        }
        return this.atom();
    }

    public String nstring() throws DecodingException {
        char next = this.nextWordChar();
        switch (next) {
            case '\"': {
                return this.consumeQuoted();
            }
            case '{': {
                return this.consumeLiteral(null);
            }
        }
        String value = this.atom();
        if ("NIL".equals(value)) {
            return null;
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid nstring value: valid values are '\"...\"', '{12} CRLF *CHAR8', and 'NIL'.");
    }

    public String mailbox() throws DecodingException {
        return ModifiedUtf7.decodeModifiedUTF7(this.mailboxUTF7());
    }

    public String mailboxUTF7() throws DecodingException {
        String mailbox = this.astring();
        if (mailbox.equalsIgnoreCase("INBOX")) {
            return "INBOX";
        }
        return mailbox;
    }

    public DayMonthYear date() throws DecodingException {
        int day;
        char one = this.consume();
        char two = this.consume();
        if (two == '-') {
            day = DecoderUtils.decodeFixedDay(' ', one);
        } else {
            day = DecoderUtils.decodeFixedDay(one, two);
            this.nextIsDash();
        }
        char monthFirstChar = this.consume();
        char monthSecondChar = this.consume();
        char monthThirdChar = this.consume();
        int month = DecoderUtils.decodeMonth(monthFirstChar, monthSecondChar, monthThirdChar) + 1;
        this.nextIsDash();
        char milleniumChar = this.consume();
        char centuryChar = this.consume();
        char decadeChar = this.consume();
        char yearChar = this.consume();
        int year = DecoderUtils.decodeYear(milleniumChar, centuryChar, decadeChar, yearChar);
        return new DayMonthYear(day, month, year);
    }

    private void nextIsDash() throws DecodingException {
        char next = this.consume();
        if (next != '-') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Expected dash but was " + next);
        }
    }

    public LocalDateTime dateTime() throws DecodingException {
        char next = this.nextWordChar();
        if (next != '\"') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "DateTime values must be quoted.");
        }
        String dateString = this.consumeQuoted();
        return DecoderUtils.decodeDateTime(dateString);
    }

    public String consumeWord(CharacterValidator validator) throws DecodingException {
        return this.consumeWord(validator, false);
    }

    private String consumeWord(CharacterValidator validator, boolean stripParen) throws DecodingException {
        StringBuilder atom = new StringBuilder();
        char next = this.nextWordChar();
        while (!(ImapRequestLineReader.isWhitespace(next) || stripParen && next == ')')) {
            if (validator.isValid(next)) {
                if (!stripParen || next != '(') {
                    atom.append(next);
                }
            } else {
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid character: '" + next + "'");
            }
            this.consume();
            next = this.nextChar();
        }
        return atom.toString();
    }

    private static boolean isWhitespace(char next) {
        return next == ' ' || next == '\n' || next == '\r' || next == '\t';
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String consumeLiteral(Charset charset) throws DecodingException {
        if (charset == null) {
            return this.consumeLiteral(StandardCharsets.US_ASCII);
        }
        try {
            ImmutablePair<Integer, Literal> literal = this.consumeLiteral(false);
            try {
                String string;
                block19: {
                    InputStream in = ((Literal)literal.right).getInputStream();
                    try {
                        Integer size = (Integer)literal.left;
                        byte[] data = IOUtils.readFully((InputStream)in, (int)size);
                        ByteBuffer buffer = ByteBuffer.wrap(data);
                        string = this.decode(charset, buffer);
                        if (in == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new DecodingException(HumanReadableText.BAD_IO_ENCODING, "Bad character encoding", e);
                        }
                    }
                    in.close();
                }
                return string;
            }
            finally {
                if (literal.right instanceof Closeable) {
                    try {
                        ((Closeable)literal.right).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException e) {
            throw new DecodingException(HumanReadableText.SOCKET_IO_FAILURE, "Could not read literal", e);
        }
    }

    public ImmutablePair<Integer, Literal> consumeLiteral(boolean extraCRLF) throws IOException {
        this.consumeChar('{');
        StringBuilder digits = new StringBuilder();
        char next = this.nextChar();
        while (next != '}' && next != '+') {
            digits.append(next);
            this.consume();
            next = this.nextChar();
        }
        boolean synchronizedLiteral = true;
        if (next == '+') {
            synchronizedLiteral = false;
            this.consumeChar('+');
        }
        this.consumeChar('}');
        this.consumeCRLF();
        if (synchronizedLiteral) {
            this.commandContinuationRequest();
        }
        try {
            int size = Integer.parseInt(digits.toString());
            if (size < 0) {
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Expected a valid positive number as literal size");
            }
            return ImmutablePair.of((Object)size, (Object)this.read(size, extraCRLF));
        }
        catch (NumberFormatException e) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Expected a valid positive number as literal size");
        }
    }

    private String decode(Charset charset, ByteBuffer buffer) throws DecodingException {
        try {
            return charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(buffer).toString();
        }
        catch (IllegalStateException | CharacterCodingException e) {
            throw new DecodingException(HumanReadableText.BAD_IO_ENCODING, "Bad character encoding", e);
        }
    }

    private void consumeCRLF() throws DecodingException {
        char next = this.nextChar();
        if (next != '\n') {
            this.consumeChar('\r');
        }
        this.consumeChar('\n');
    }

    public void consumeChar(char expected) throws DecodingException {
        char consumed = this.consume();
        if (consumed != expected) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Expected:'" + expected + "' found:'" + consumed + "'");
        }
    }

    public String consumeQuoted() throws DecodingException {
        return this.consumeQuoted(null);
    }

    protected String consumeQuoted(Charset charset) throws DecodingException {
        if (charset == null) {
            return this.consumeQuoted(StandardCharsets.US_ASCII);
        }
        this.consumeChar('\"');
        QuotedStringDecoder decoder = new QuotedStringDecoder(charset);
        String result = decoder.decode(this);
        this.consumeChar('\"');
        return result;
    }

    public Flags flagList() throws DecodingException {
        int parenIndex;
        Flags flags = new Flags();
        this.nextWordChar();
        this.consumeChar('(');
        NoopCharValidator validator = new NoopCharValidator();
        String nextWord = this.consumeWord(validator);
        while (!nextWord.endsWith(")")) {
            DecoderUtils.setFlag(nextWord, flags);
            nextWord = this.consumeWord(validator);
            if (!nextWord.isEmpty()) continue;
            throw new DecodingException(HumanReadableText.FAILED, "Empty word encountered");
        }
        if (nextWord.length() > 1 && (parenIndex = nextWord.indexOf(41)) > 0) {
            String nextFlag = nextWord.substring(0, parenIndex);
            DecoderUtils.setFlag(nextFlag, flags);
        }
        return flags;
    }

    public Flags flag() throws DecodingException {
        Flags flags = new Flags();
        this.nextWordChar();
        NoopCharValidator validator = new NoopCharValidator();
        String nextFlag = this.consumeWord(validator);
        DecoderUtils.setFlag(nextFlag, flags);
        return flags;
    }

    public long number() throws DecodingException {
        return this.number(false);
    }

    public long number(boolean stopOnParen) throws DecodingException {
        return this.readDigits(0, 0L, true, stopOnParen);
    }

    private long readDigits(int add, long total, boolean first, boolean stopOnParen) throws DecodingException {
        char next;
        if (first) {
            next = this.nextWordChar();
        } else {
            this.consume();
            next = this.nextChar();
        }
        long currentTotal = 10L * total + (long)add;
        switch (next) {
            case '0': {
                return this.readDigits(0, currentTotal, false, stopOnParen);
            }
            case '1': {
                return this.readDigits(1, currentTotal, false, stopOnParen);
            }
            case '2': {
                return this.readDigits(2, currentTotal, false, stopOnParen);
            }
            case '3': {
                return this.readDigits(3, currentTotal, false, stopOnParen);
            }
            case '4': {
                return this.readDigits(4, currentTotal, false, stopOnParen);
            }
            case '5': {
                return this.readDigits(5, currentTotal, false, stopOnParen);
            }
            case '6': {
                return this.readDigits(6, currentTotal, false, stopOnParen);
            }
            case '7': {
                return this.readDigits(7, currentTotal, false, stopOnParen);
            }
            case '8': {
                return this.readDigits(8, currentTotal, false, stopOnParen);
            }
            case '9': {
                return this.readDigits(9, currentTotal, false, stopOnParen);
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': 
            case '.': 
            case '>': {
                return currentTotal;
            }
            case ')': {
                if (stopOnParen) {
                    return currentTotal;
                }
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Expected a digit but was " + next);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Expected a digit but was " + next);
    }

    public long nzNumber() throws DecodingException {
        long number = this.number();
        if (number == 0L) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Zero value not permitted.");
        }
        return number;
    }

    public static boolean isCHAR(char chr) {
        return chr >= '\u0001' && chr <= '\u007f';
    }

    public static boolean isListWildcard(char chr) {
        return chr == '*' || chr == '%';
    }

    public static boolean isQuotedSpecial(char chr) {
        return chr == '\"' || chr == '\\';
    }

    public IdRange[] parseIdRange() throws DecodingException {
        return this.parseIdRange(null);
    }

    public IdRange[] parseIdRange(ImapSession session) throws DecodingException {
        String range;
        char c;
        if (session != null && (c = this.nextWordChar()) == '$') {
            this.consume();
            return SearchResUtil.getSavedSequenceSet(session);
        }
        MessageSetCharValidator validator = new MessageSetCharValidator();
        String nextWord = this.consumeWord(validator, true);
        int commaPos = nextWord.indexOf(44);
        if (commaPos == -1) {
            return new IdRange[]{this.parseRange(nextWord)};
        }
        ArrayList<IdRange> rangeList = new ArrayList<IdRange>();
        int pos = 0;
        while (commaPos != -1) {
            range = nextWord.substring(pos, commaPos);
            IdRange set = this.parseRange(range);
            rangeList.add(set);
            pos = commaPos + 1;
            commaPos = nextWord.indexOf(44, pos);
        }
        range = nextWord.substring(pos);
        rangeList.add(this.parseRange(range));
        List<IdRange> merged = IdRange.mergeRanges(rangeList);
        return (IdRange[])merged.toArray(IdRange[]::new);
    }

    public UidRange[] parseUidRange() throws DecodingException {
        String range;
        MessageSetCharValidator validator = new MessageSetCharValidator();
        String nextWord = this.consumeWord(validator, true);
        int commaPos = nextWord.indexOf(44);
        if (commaPos == -1) {
            return new UidRange[]{this.parseUidRange(nextWord)};
        }
        ArrayList<UidRange> rangeList = new ArrayList<UidRange>();
        int pos = 0;
        while (commaPos != -1) {
            range = nextWord.substring(pos, commaPos);
            UidRange set = this.parseUidRange(range);
            rangeList.add(set);
            pos = commaPos + 1;
            commaPos = nextWord.indexOf(44, pos);
        }
        range = nextWord.substring(pos);
        rangeList.add(this.parseUidRange(range));
        List<UidRange> merged = UidRange.mergeRanges(rangeList);
        return (UidRange[])merged.toArray(UidRange[]::new);
    }

    public char nextNonSpaceChar() throws DecodingException {
        char next = this.nextChar();
        while (next == ' ') {
            this.consume();
            next = this.nextChar();
        }
        return next;
    }

    private IdRange parseRange(String range) throws DecodingException {
        int pos = range.indexOf(58);
        try {
            if (pos == -1) {
                if (range.length() == 1 && range.charAt(0) == '*') {
                    return new IdRange(Long.MAX_VALUE, Long.MAX_VALUE);
                }
                long value = this.parseUnsignedInteger(range);
                return new IdRange(value);
            }
            long val1 = this.parseUnsignedInteger(range.substring(0, pos));
            long val2 = this.parseUnsignedInteger(range.substring(pos + 1));
            if (val1 == Long.MAX_VALUE && val2 == Long.MAX_VALUE) {
                return new IdRange(Long.MAX_VALUE, Long.MAX_VALUE);
            }
            if (val1 <= val2) {
                return new IdRange(val1, val2);
            }
            if (val1 == Long.MAX_VALUE) {
                return new IdRange(val2, Long.MAX_VALUE);
            }
            return new IdRange(val2, val1);
        }
        catch (NumberFormatException e) {
            throw new DecodingException(HumanReadableText.INVALID_MESSAGESET, "Invalid message set.", e);
        }
    }

    private UidRange parseUidRange(String range) throws DecodingException {
        int pos = range.indexOf(58);
        try {
            if (pos == -1) {
                if (range.length() == 1 && range.charAt(0) == '*') {
                    return new UidRange(MessageUid.MAX_VALUE);
                }
                long value = this.parseUnsignedInteger(range);
                return new UidRange(MessageUid.of((long)value));
            }
            long val1 = this.parseUnsignedInteger(range.substring(0, pos));
            long val2 = this.parseUnsignedInteger(range.substring(pos + 1));
            if (val1 == Long.MAX_VALUE && val2 == Long.MAX_VALUE) {
                return new UidRange(MessageUid.MAX_VALUE);
            }
            if (val1 <= val2) {
                return new UidRange(MessageUid.of((long)val1), MessageUid.of((long)val2));
            }
            if (val1 == Long.MAX_VALUE) {
                return new UidRange(MessageUid.of((long)val2), MessageUid.MAX_VALUE);
            }
            return new UidRange(MessageUid.of((long)val2), MessageUid.of((long)val1));
        }
        catch (NumberFormatException e) {
            throw new DecodingException(HumanReadableText.INVALID_MESSAGESET, "Invalid message set.", e);
        }
    }

    private long parseUnsignedInteger(String value) throws DecodingException {
        if (value.length() == 1 && value.charAt(0) == '*') {
            return Long.MAX_VALUE;
        }
        long number = Long.parseLong(value);
        if (number < 1L || number > 0xFFFFFFFFL) {
            throw new DecodingException(HumanReadableText.INVALID_MESSAGESET, "Invalid message set. Numbers must be unsigned 32-bit Integers");
        }
        return number;
    }

    public static class AtomCharValidator
    implements CharacterValidator {
        @Override
        public boolean isValid(char chr) {
            return ImapRequestLineReader.isCHAR(chr) && !this.isAtomSpecial(chr) && !ImapRequestLineReader.isListWildcard(chr) && !ImapRequestLineReader.isQuotedSpecial(chr);
        }

        private boolean isAtomSpecial(char chr) {
            return chr == '(' || chr == ')' || chr == '{' || chr == ' ' || chr == '\u000f';
        }
    }

    public static interface CharacterValidator {
        public boolean isValid(char var1);
    }

    public static class TagCharValidator
    extends AtomCharValidator {
        @Override
        public boolean isValid(char chr) {
            if (chr == '+') {
                return false;
            }
            return super.isValid(chr);
        }
    }

    private static class QuotedStringDecoder {
        private final CharsetDecoder decoder;
        private final ByteBuffer buffer;
        CharBuffer charBuffer;

        public QuotedStringDecoder(Charset charset) {
            this.decoder = charset.newDecoder();
            this.buffer = ByteBuffer.allocate(64);
            this.charBuffer = CharBuffer.allocate(64);
        }

        public String decode(ImapRequestLineReader request) throws DecodingException {
            try {
                this.decoder.reset();
                char next = request.nextChar();
                while (next != '\"') {
                    if (!this.buffer.hasRemaining()) {
                        this.decodeByteBufferToCharacterBuffer(false);
                    }
                    if (next == '\\') {
                        request.consume();
                        next = request.nextChar();
                        if (!ImapRequestLineReader.isQuotedSpecial(next)) {
                            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid escaped character in quote: '" + next + "'");
                        }
                    }
                    this.buffer.put((byte)next);
                    request.consume();
                    next = request.nextChar();
                }
                this.completeDecoding();
                return this.charBuffer.toString();
            }
            catch (IllegalStateException e) {
                throw new DecodingException(HumanReadableText.BAD_IO_ENCODING, "Bad character encoding", e);
            }
        }

        private void completeDecoding() throws DecodingException {
            this.decodeByteBufferToCharacterBuffer(true);
            this.flush();
            this.charBuffer.flip();
        }

        private void flush() throws DecodingException {
            CoderResult coderResult = this.decoder.flush(this.charBuffer);
            if (coderResult.isOverflow()) {
                this.upsizeCharBuffer();
                this.flush();
            } else if (coderResult.isError()) {
                throw new DecodingException(HumanReadableText.BAD_IO_ENCODING, "Bad character encoding");
            }
        }

        private CoderResult decodeByteBufferToCharacterBuffer(boolean endOfInput) throws DecodingException {
            this.buffer.flip();
            return this.decodeMoreBytesToCharacterBuffer(endOfInput);
        }

        private CoderResult decodeMoreBytesToCharacterBuffer(boolean endOfInput) throws DecodingException {
            CoderResult coderResult = this.decoder.decode(this.buffer, this.charBuffer, endOfInput);
            if (coderResult.isOverflow()) {
                this.upsizeCharBuffer();
                return this.decodeMoreBytesToCharacterBuffer(endOfInput);
            }
            if (coderResult.isError()) {
                throw new DecodingException(HumanReadableText.BAD_IO_ENCODING, "Bad character encoding");
            }
            if (coderResult.isUnderflow()) {
                this.buffer.clear();
            }
            return coderResult;
        }

        private void upsizeCharBuffer() {
            int oldCapacity = this.charBuffer.capacity();
            CharBuffer oldBuffer = this.charBuffer;
            this.charBuffer = CharBuffer.allocate(oldCapacity + 64);
            oldBuffer.flip();
            this.charBuffer.put(oldBuffer);
        }
    }

    public static class NoopCharValidator
    implements CharacterValidator {
        @Override
        public boolean isValid(char chr) {
            return true;
        }
    }

    public static class MessageSetCharValidator
    implements CharacterValidator {
        @Override
        public boolean isValid(char chr) {
            return this.isDigit(chr) || chr == ':' || chr == '*' || chr == ',';
        }

        private boolean isDigit(char chr) {
            return '0' <= chr && chr <= '9';
        }
    }

    public static class StringMatcherCharacterValidator
    implements CharacterValidator {
        private final String expectedString;
        private int position = 0;

        public static StringMatcherCharacterValidator ignoreCase(String expectedString) {
            return new StringMatcherCharacterValidator(expectedString);
        }

        static boolean asciiEqualsIgnoringCase(Character c1, Character c2) {
            return Character.toUpperCase(c1.charValue()) == Character.toUpperCase(c2.charValue());
        }

        private StringMatcherCharacterValidator(String expectedString) {
            this.expectedString = expectedString;
        }

        @Override
        public boolean isValid(char chr) {
            if (this.position >= this.expectedString.length()) {
                return false;
            }
            return StringMatcherCharacterValidator.asciiEqualsIgnoringCase(Character.valueOf(chr), Character.valueOf(this.expectedString.charAt(this.position++)));
        }
    }
}

