/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.apache.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import net.savignano.thirdparty.org.bouncycastle.apache.bzip2.BZip2Constants;
import net.savignano.thirdparty.org.bouncycastle.apache.bzip2.CRC;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Integers;

public class CBZip2OutputStream
extends OutputStream
implements BZip2Constants {
    protected static final int SETMASK = 0x200000;
    protected static final int CLEARMASK = -2097153;
    protected static final int GREATER_ICOST = 15;
    protected static final int LESSER_ICOST = 0;
    protected static final int SMALL_THRESH = 20;
    protected static final int DEPTH_THRESH = 10;
    static final short[] R_NUMS = new short[]{619, 720, 127, 481, 931, 816, 813, 233, 566, 247, 985, 724, 205, 454, 863, 491, 741, 242, 949, 214, 733, 859, 335, 708, 621, 574, 73, 654, 730, 472, 419, 436, 278, 496, 867, 210, 399, 680, 480, 51, 878, 465, 811, 169, 869, 675, 611, 697, 867, 561, 862, 687, 507, 283, 482, 129, 807, 591, 733, 623, 150, 238, 59, 379, 684, 877, 625, 169, 643, 105, 170, 607, 520, 932, 727, 476, 693, 425, 174, 647, 73, 122, 335, 530, 442, 853, 695, 249, 445, 515, 909, 545, 703, 919, 874, 474, 882, 500, 594, 612, 641, 801, 220, 162, 819, 984, 589, 513, 495, 799, 161, 604, 958, 533, 221, 400, 386, 867, 600, 782, 382, 596, 414, 171, 516, 375, 682, 485, 911, 276, 98, 553, 163, 354, 666, 933, 424, 341, 533, 870, 227, 730, 475, 186, 263, 647, 537, 686, 600, 224, 469, 68, 770, 919, 190, 373, 294, 822, 808, 206, 184, 943, 795, 384, 383, 461, 404, 758, 839, 887, 715, 67, 618, 276, 204, 918, 873, 777, 604, 560, 951, 160, 578, 722, 79, 804, 96, 409, 713, 940, 652, 934, 970, 447, 318, 353, 859, 672, 112, 785, 645, 863, 803, 350, 139, 93, 354, 99, 820, 908, 609, 772, 154, 274, 580, 184, 79, 626, 630, 742, 653, 282, 762, 623, 680, 81, 927, 626, 789, 125, 411, 521, 938, 300, 821, 78, 343, 175, 128, 250, 170, 774, 972, 275, 999, 639, 495, 78, 352, 126, 857, 956, 358, 619, 580, 124, 737, 594, 701, 612, 669, 112, 134, 694, 363, 992, 809, 743, 168, 974, 944, 375, 748, 52, 600, 747, 642, 182, 862, 81, 344, 805, 988, 739, 511, 655, 814, 334, 249, 515, 897, 955, 664, 981, 649, 113, 974, 459, 893, 228, 433, 837, 553, 268, 926, 240, 102, 654, 459, 51, 686, 754, 806, 760, 493, 403, 415, 394, 687, 700, 946, 670, 656, 610, 738, 392, 760, 799, 887, 653, 978, 321, 576, 617, 626, 502, 894, 679, 243, 440, 680, 879, 194, 572, 640, 724, 926, 56, 204, 700, 707, 151, 457, 449, 797, 195, 791, 558, 945, 679, 297, 59, 87, 824, 713, 663, 412, 693, 342, 606, 134, 108, 571, 364, 631, 212, 174, 643, 304, 329, 343, 97, 430, 751, 497, 314, 983, 374, 822, 928, 140, 206, 73, 263, 980, 736, 876, 478, 430, 305, 170, 514, 364, 692, 829, 82, 855, 953, 676, 246, 369, 970, 294, 750, 807, 827, 150, 790, 288, 923, 804, 378, 215, 828, 592, 281, 565, 555, 710, 82, 896, 831, 547, 261, 524, 462, 293, 465, 502, 56, 661, 821, 976, 991, 658, 869, 905, 758, 745, 193, 768, 550, 608, 933, 378, 286, 215, 979, 792, 961, 61, 688, 793, 644, 986, 403, 106, 366, 905, 644, 372, 567, 466, 434, 645, 210, 389, 550, 919, 135, 780, 773, 635, 389, 707, 100, 626, 958, 165, 504, 920, 176, 193, 713, 857, 265, 203, 50, 668, 108, 645, 990, 626, 197, 510, 357, 358, 850, 858, 364, 936, 638};
    private static final int[] INCS = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};
    private boolean finished;
    int count;
    int origPtr;
    private final int blockSize100k;
    private final int allowableBlockSize;
    boolean blockRandomised;
    private final Vector blocksortStack = new Vector();
    int bsBuff;
    int bsLivePos;
    private final CRC blockCRC = new CRC();
    private boolean[] inUse = new boolean[256];
    private int nInUse;
    private byte[] selectors = new byte[18002];
    private byte[] blockBytes = null;
    private short[] quadrantShorts = null;
    private int[] zptr = null;
    private int[] szptr;
    private int[] ftab = null;
    private int nMTF;
    private int[] mtfFreq = new int[258];
    private int workFactor;
    private int workDone;
    private int workLimit;
    private boolean firstAttempt;
    private int currentByte = -1;
    private int runLength = 0;
    private int streamCRC;
    boolean closed = false;
    private OutputStream bsStream;

    protected static void hbMakeCodeLengths(byte[] len, int[] freq, int alphaSize, int maxLen) {
        int i;
        int[] heap = new int[260];
        int[] weight = new int[516];
        int[] parent = new int[516];
        for (i = 0; i < alphaSize; ++i) {
            weight[i + 1] = (freq[i] == 0 ? 1 : freq[i]) << 8;
        }
        block1: while (true) {
            int j;
            int tmp;
            int zz;
            int nNodes = alphaSize;
            int nHeap = 0;
            heap[0] = 0;
            weight[0] = 0;
            parent[0] = -2;
            for (i = 1; i <= alphaSize; ++i) {
                parent[i] = -1;
                heap[++nHeap] = i;
                zz = nHeap;
                tmp = heap[zz];
                while (weight[tmp] < weight[heap[zz >> 1]]) {
                    heap[zz] = heap[zz >> 1];
                    zz >>= 1;
                }
                heap[zz] = tmp;
            }
            if (nHeap >= 260) {
                throw new IllegalStateException();
            }
            while (nHeap > 1) {
                int n1 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                int yy = 0;
                int tmp2 = 0;
                zz = 1;
                tmp2 = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weight[heap[yy + 1]] < weight[heap[yy]]) {
                        ++yy;
                    }
                    if (weight[tmp2] < weight[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp2;
                int n2 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                yy = 0;
                tmp2 = 0;
                zz = 1;
                tmp2 = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weight[heap[yy + 1]] < weight[heap[yy]]) {
                        ++yy;
                    }
                    if (weight[tmp2] < weight[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp2;
                parent[n1] = parent[n2] = ++nNodes;
                weight[nNodes] = (weight[n1] & 0xFFFFFF00) + (weight[n2] & 0xFFFFFF00) | 1 + ((weight[n1] & 0xFF) > (weight[n2] & 0xFF) ? weight[n1] & 0xFF : weight[n2] & 0xFF);
                parent[nNodes] = -1;
                heap[++nHeap] = nNodes;
                zz = 0;
                tmp = 0;
                zz = nHeap;
                tmp = heap[zz];
                while (weight[tmp] < weight[heap[zz >> 1]]) {
                    heap[zz] = heap[zz >> 1];
                    zz >>= 1;
                }
                heap[zz] = tmp;
            }
            if (nNodes >= 516) {
                throw new IllegalStateException();
            }
            int tooLongBits = 0;
            for (i = 1; i <= alphaSize; ++i) {
                j = 0;
                int k = i;
                while (parent[k] >= 0) {
                    k = parent[k];
                    ++j;
                }
                len[i - 1] = (byte)j;
                tooLongBits |= maxLen - j;
            }
            if (tooLongBits >= 0) break;
            i = 1;
            while (true) {
                if (i > alphaSize) continue block1;
                j = weight[i] >> 8;
                j = 1 + j / 2;
                weight[i] = j << 8;
                ++i;
            }
            break;
        }
    }

    public CBZip2OutputStream(OutputStream outStream) throws IOException {
        this(outStream, 9);
    }

    public CBZip2OutputStream(OutputStream outStream, int blockSize) throws IOException {
        outStream.write(66);
        outStream.write(90);
        this.bsStream = outStream;
        this.bsBuff = 0;
        this.bsLivePos = 32;
        this.workFactor = 50;
        if (blockSize > 9) {
            blockSize = 9;
        } else if (blockSize < 1) {
            blockSize = 1;
        }
        this.blockSize100k = blockSize;
        this.allowableBlockSize = 100000 * this.blockSize100k - 20;
        int n = 100000 * this.blockSize100k;
        this.blockBytes = new byte[n + 1 + 20];
        this.quadrantShorts = new short[n + 1 + 20];
        this.zptr = new int[n];
        this.ftab = new int[65537];
        this.szptr = this.zptr;
        outStream.write(104);
        outStream.write(48 + this.blockSize100k);
        this.streamCRC = 0;
        this.initBlock();
    }

    @Override
    public void write(int bv) throws IOException {
        int b = bv & 0xFF;
        if (this.currentByte == b) {
            if (++this.runLength > 254) {
                this.writeRun();
                this.currentByte = -1;
                this.runLength = 0;
            }
            return;
        }
        if (this.currentByte >= 0) {
            this.writeRun();
        }
        this.currentByte = b;
        this.runLength = 1;
    }

    private void writeRun() throws IOException {
        if (this.count > this.allowableBlockSize) {
            this.endBlock();
            this.initBlock();
        }
        this.inUse[this.currentByte] = true;
        switch (this.runLength) {
            case 1: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockCRC.update(this.currentByte);
                break;
            }
            case 2: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockCRC.update(this.currentByte);
                this.blockCRC.update(this.currentByte);
                break;
            }
            case 3: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockCRC.update(this.currentByte);
                this.blockCRC.update(this.currentByte);
                this.blockCRC.update(this.currentByte);
                break;
            }
            default: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)(this.runLength - 4);
                this.inUse[this.runLength - 4] = true;
                this.blockCRC.updateRun(this.currentByte, this.runLength);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.finish();
        this.closed = true;
        super.close();
        this.bsStream.close();
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        if (this.runLength > 0) {
            this.writeRun();
        }
        this.currentByte = -1;
        if (this.count > 0) {
            this.endBlock();
        }
        this.endCompression();
        this.finished = true;
        this.flush();
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.bsStream.flush();
    }

    private void initBlock() {
        this.blockCRC.initialise();
        this.count = 0;
        for (int i = 0; i < 256; ++i) {
            this.inUse[i] = false;
        }
    }

    private void endBlock() throws IOException {
        int blockFinalCRC = this.blockCRC.getFinal();
        this.streamCRC = Integers.rotateLeft(this.streamCRC, 1) ^ blockFinalCRC;
        this.doReversibleTransformation();
        this.bsPutLong48(54156738319193L);
        this.bsPutInt32(blockFinalCRC);
        this.bsPutBit(this.blockRandomised ? 1 : 0);
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutLong48(25779555029136L);
        this.bsPutInt32(this.streamCRC);
        this.bsFinishedWithStream();
    }

    private void hbAssignCodes(int[] code, byte[] length, int minLen, int maxLen, int alphaSize) {
        int vec = 0;
        for (int n = minLen; n <= maxLen; ++n) {
            for (int i = 0; i < alphaSize; ++i) {
                if ((length[i] & 0xFF) != n) continue;
                code[i] = vec++;
            }
            vec <<= 1;
        }
    }

    private void bsFinishedWithStream() throws IOException {
        if (this.bsLivePos < 32) {
            this.bsStream.write(this.bsBuff >>> 24);
            this.bsBuff = 0;
            this.bsLivePos = 32;
        }
    }

    private void bsPutBit(int v) throws IOException {
        --this.bsLivePos;
        this.bsBuff |= v << this.bsLivePos;
        if (this.bsLivePos <= 24) {
            this.bsStream.write(this.bsBuff >>> 24);
            this.bsBuff <<= 8;
            this.bsLivePos += 8;
        }
    }

    private void bsPutBits(int n, int v) throws IOException {
        this.bsLivePos -= n;
        this.bsBuff |= v << this.bsLivePos;
        while (this.bsLivePos <= 24) {
            this.bsStream.write(this.bsBuff >>> 24);
            this.bsBuff <<= 8;
            this.bsLivePos += 8;
        }
    }

    private void bsPutBitsSmall(int n, int v) throws IOException {
        this.bsLivePos -= n;
        this.bsBuff |= v << this.bsLivePos;
        if (this.bsLivePos <= 24) {
            this.bsStream.write(this.bsBuff >>> 24);
            this.bsBuff <<= 8;
            this.bsLivePos += 8;
        }
    }

    private void bsPutInt32(int u) throws IOException {
        this.bsPutBits(16, u >>> 16);
        this.bsPutBits(16, u & 0xFFFF);
    }

    private void bsPutLong48(long u) throws IOException {
        this.bsPutBits(24, (int)(u >>> 24) & 0xFFFFFF);
        this.bsPutBits(24, (int)u & 0xFFFFFF);
    }

    private void sendMTFValues() throws IOException {
        int j;
        int i;
        int v;
        int t;
        int alphaSize = this.nInUse + 2;
        if (this.nMTF <= 0) {
            throw new IllegalStateException();
        }
        int nGroups = this.nMTF < 200 ? 2 : (this.nMTF < 600 ? 3 : (this.nMTF < 1200 ? 4 : (this.nMTF < 2400 ? 5 : 6)));
        byte[][] len = new byte[nGroups][alphaSize];
        for (t = 0; t < nGroups; ++t) {
            Arrays.fill(len[t], (byte)15);
        }
        int nPart = nGroups;
        int remF = this.nMTF;
        int ge = -1;
        while (nPart > 0) {
            int aFreq;
            int gs = ge + 1;
            int tFreq = remF / nPart;
            for (aFreq = 0; aFreq < tFreq && ge < alphaSize - 1; aFreq += this.mtfFreq[++ge]) {
            }
            if (ge > gs && nPart != nGroups && nPart != 1 && (nGroups - nPart) % 2 == 1) {
                aFreq -= this.mtfFreq[ge];
                --ge;
            }
            byte[] len_np = len[nPart - 1];
            for (v = 0; v < alphaSize; ++v) {
                len_np[v] = v >= gs && v <= ge ? 0 : 15;
            }
            --nPart;
            remF -= aFreq;
        }
        int[][] rfreq = new int[6][258];
        int[] fave = new int[6];
        short[] cost = new short[6];
        int nSelectors = 0;
        for (int iter = 0; iter < 4; ++iter) {
            for (t = 0; t < nGroups; ++t) {
                fave[t] = 0;
                int[] rfreq_t = rfreq[t];
                for (v = 0; v < alphaSize; ++v) {
                    rfreq_t[v] = 0;
                }
            }
            nSelectors = 0;
            int gs = 0;
            while (gs < this.nMTF) {
                int ge2 = Math.min(gs + 50 - 1, this.nMTF - 1);
                if (nGroups == 6) {
                    byte[] len_0 = len[0];
                    byte[] len_1 = len[1];
                    byte[] len_2 = len[2];
                    byte[] len_3 = len[3];
                    byte[] len_4 = len[4];
                    byte[] len_5 = len[5];
                    short cost0 = 0;
                    short cost1 = 0;
                    short cost2 = 0;
                    short cost3 = 0;
                    short cost4 = 0;
                    short cost5 = 0;
                    for (i = gs; i <= ge2; ++i) {
                        int icv = this.szptr[i];
                        cost0 = (short)(cost0 + (len_0[icv] & 0xFF));
                        cost1 = (short)(cost1 + (len_1[icv] & 0xFF));
                        cost2 = (short)(cost2 + (len_2[icv] & 0xFF));
                        cost3 = (short)(cost3 + (len_3[icv] & 0xFF));
                        cost4 = (short)(cost4 + (len_4[icv] & 0xFF));
                        cost5 = (short)(cost5 + (len_5[icv] & 0xFF));
                    }
                    cost[0] = cost0;
                    cost[1] = cost1;
                    cost[2] = cost2;
                    cost[3] = cost3;
                    cost[4] = cost4;
                    cost[5] = cost5;
                } else {
                    for (t = 0; t < nGroups; ++t) {
                        cost[t] = 0;
                    }
                    for (i = gs; i <= ge2; ++i) {
                        int icv = this.szptr[i];
                        for (t = 0; t < nGroups; ++t) {
                            int n = t;
                            cost[n] = (short)(cost[n] + (len[t][icv] & 0xFF));
                        }
                    }
                }
                short bc = cost[0];
                int bt = 0;
                for (t = 1; t < nGroups; ++t) {
                    short cost_t = cost[t];
                    if (cost_t >= bc) continue;
                    bc = cost_t;
                    bt = t;
                }
                int n = bt;
                fave[n] = fave[n] + 1;
                this.selectors[nSelectors] = (byte)bt;
                ++nSelectors;
                int[] rfreq_bt = rfreq[bt];
                for (i = gs; i <= ge2; ++i) {
                    int n2 = this.szptr[i];
                    rfreq_bt[n2] = rfreq_bt[n2] + 1;
                }
                gs = ge2 + 1;
            }
            for (t = 0; t < nGroups; ++t) {
                CBZip2OutputStream.hbMakeCodeLengths(len[t], rfreq[t], alphaSize, 17);
            }
        }
        if (nGroups >= 8 || nGroups > 6) {
            throw new IllegalStateException();
        }
        if (nSelectors >= 32768 || nSelectors > 18002) {
            throw new IllegalStateException();
        }
        int[][] code = new int[nGroups][alphaSize];
        for (t = 0; t < nGroups; ++t) {
            int maxLen = 0;
            int minLen = 32;
            byte[] len_t = len[t];
            for (i = 0; i < alphaSize; ++i) {
                int lti = len_t[i] & 0xFF;
                maxLen = Math.max(maxLen, lti);
                minLen = Math.min(minLen, lti);
            }
            if (minLen < 1 | maxLen > 17) {
                throw new IllegalStateException();
            }
            this.hbAssignCodes(code[t], len_t, minLen, maxLen, alphaSize);
        }
        boolean[] inUse16 = new boolean[16];
        block17: for (i = 0; i < 16; ++i) {
            inUse16[i] = false;
            int i16 = i * 16;
            for (j = 0; j < 16; ++j) {
                if (!this.inUse[i16 + j]) continue;
                inUse16[i] = true;
                continue block17;
            }
        }
        for (i = 0; i < 16; ++i) {
            this.bsPutBit(inUse16[i] ? 1 : 0);
        }
        for (i = 0; i < 16; ++i) {
            if (!inUse16[i]) continue;
            int i16 = i * 16;
            for (j = 0; j < 16; ++j) {
                this.bsPutBit(this.inUse[i16 + j] ? 1 : 0);
            }
        }
        this.bsPutBitsSmall(3, nGroups);
        this.bsPutBits(15, nSelectors);
        int mtfSelectors = 6636321;
        for (i = 0; i < nSelectors; ++i) {
            int ll_i = this.selectors[i] & 0xFF;
            int bitPos = ll_i << 2;
            int mtfSelector = mtfSelectors >>> bitPos & 0xF;
            if (mtfSelector != 1) {
                int mtfIncMask = 0x888888 - mtfSelectors + 0x111111 * mtfSelector & 0x888888;
                mtfSelectors = mtfSelectors - (mtfSelector << bitPos) + (mtfIncMask >>> 3);
            }
            this.bsPutBitsSmall(mtfSelector, (1 << mtfSelector) - 2);
        }
        for (t = 0; t < nGroups; ++t) {
            byte[] len_t = len[t];
            int curr = len_t[0] & 0xFF;
            this.bsPutBitsSmall(6, curr << 1);
            for (i = 1; i < alphaSize; ++i) {
                int lti = len_t[i] & 0xFF;
                while (curr < lti) {
                    this.bsPutBitsSmall(2, 2);
                    ++curr;
                }
                while (curr > lti) {
                    this.bsPutBitsSmall(2, 3);
                    --curr;
                }
                this.bsPutBit(0);
            }
        }
        int selCtr = 0;
        int gs = 0;
        while (gs < this.nMTF) {
            int ge3 = Math.min(gs + 50 - 1, this.nMTF - 1);
            int selector_selCtr = this.selectors[selCtr] & 0xFF;
            byte[] len_selCtr = len[selector_selCtr];
            int[] code_selCtr = code[selector_selCtr];
            for (i = gs; i <= ge3; ++i) {
                int sfmap_i = this.szptr[i];
                this.bsPutBits(len_selCtr[sfmap_i] & 0xFF, code_selCtr[sfmap_i]);
            }
            gs = ge3 + 1;
            ++selCtr;
        }
        if (selCtr != nSelectors) {
            throw new IllegalStateException();
        }
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutBits(24, this.origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void simpleSort(int lo, int hi, int d) {
        int bigN = hi - lo + 1;
        if (bigN < 2) {
            return;
        }
        int hp = 0;
        while (INCS[hp] < bigN) {
            ++hp;
        }
        --hp;
        while (hp >= 0) {
            int h = INCS[hp];
            for (int i = lo + h; i <= hi; ++i) {
                int v = this.zptr[i];
                int j = i;
                while (this.fullGtU(this.zptr[j - h] + d, v + d)) {
                    this.zptr[j] = this.zptr[j - h];
                    if ((j -= h) > lo + h - 1) continue;
                }
                this.zptr[j] = v;
                if (++i > hi) break;
                v = this.zptr[i];
                j = i;
                while (this.fullGtU(this.zptr[j - h] + d, v + d)) {
                    this.zptr[j] = this.zptr[j - h];
                    if ((j -= h) > lo + h - 1) continue;
                }
                this.zptr[j] = v;
                if (++i > hi) break;
                v = this.zptr[i];
                j = i;
                while (this.fullGtU(this.zptr[j - h] + d, v + d)) {
                    this.zptr[j] = this.zptr[j - h];
                    if ((j -= h) > lo + h - 1) continue;
                }
                this.zptr[j] = v;
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            --hp;
        }
    }

    private void vswap(int p1, int p2, int n) {
        while (--n >= 0) {
            int t1 = this.zptr[p1];
            int t2 = this.zptr[p2];
            this.zptr[p1++] = t2;
            this.zptr[p2++] = t1;
        }
    }

    private int med3(int a, int b, int c) {
        return a > b ? (c < b ? b : (c > a ? a : c)) : (c < a ? a : (c > b ? b : c));
    }

    private static void pushStackElem(Vector stack, int stackCount, int ll, int hh, int dd) {
        StackElem stackElem;
        if (stackCount < stack.size()) {
            stackElem = (StackElem)stack.elementAt(stackCount);
        } else {
            stackElem = new StackElem();
            stack.addElement(stackElem);
        }
        stackElem.ll = ll;
        stackElem.hh = hh;
        stackElem.dd = dd;
    }

    private void qSort3(int loSt, int hiSt, int dSt) {
        Vector stack = this.blocksortStack;
        int stackCount = 0;
        int lo = loSt;
        int hi = hiSt;
        int d = dSt;
        while (true) {
            int n;
            int gtHi;
            int ltLo;
            if (hi - lo < 20 || d > 10) {
                this.simpleSort(lo, hi, d);
                if (stackCount < 1 || this.workDone > this.workLimit && this.firstAttempt) {
                    return;
                }
                StackElem stackElem = (StackElem)stack.elementAt(--stackCount);
                lo = stackElem.ll;
                hi = stackElem.hh;
                d = stackElem.dd;
                continue;
            }
            int d1 = d + 1;
            int med = this.med3(this.blockBytes[this.zptr[lo] + d1] & 0xFF, this.blockBytes[this.zptr[hi] + d1] & 0xFF, this.blockBytes[this.zptr[lo + hi >>> 1] + d1] & 0xFF);
            int unLo = ltLo = lo;
            int unHi = gtHi = hi;
            while (true) {
                int zUnHi;
                int zUnLo;
                if (unLo <= unHi && (n = (this.blockBytes[(zUnLo = this.zptr[unLo]) + d1] & 0xFF) - med) <= 0) {
                    if (n == 0) {
                        this.zptr[unLo] = this.zptr[ltLo];
                        this.zptr[ltLo++] = zUnLo;
                    }
                    ++unLo;
                    continue;
                }
                while (unLo <= unHi && (n = (this.blockBytes[(zUnHi = this.zptr[unHi]) + d1] & 0xFF) - med) >= 0) {
                    if (n == 0) {
                        this.zptr[unHi] = this.zptr[gtHi];
                        this.zptr[gtHi--] = zUnHi;
                    }
                    --unHi;
                }
                if (unLo > unHi) break;
                int temp = this.zptr[unLo];
                this.zptr[unLo++] = this.zptr[unHi];
                this.zptr[unHi--] = temp;
            }
            if (gtHi < ltLo) {
                d = d1;
                continue;
            }
            n = Math.min(ltLo - lo, unLo - ltLo);
            this.vswap(lo, unLo - n, n);
            int m = Math.min(hi - gtHi, gtHi - unHi);
            this.vswap(unLo, hi - m + 1, m);
            n = lo + (unLo - ltLo);
            m = hi - (gtHi - unHi);
            CBZip2OutputStream.pushStackElem(stack, stackCount++, lo, n - 1, d);
            CBZip2OutputStream.pushStackElem(stack, stackCount++, n, m, d1);
            lo = m + 1;
        }
    }

    private void mainSort() {
        int i;
        int[] runningOrder = new int[256];
        int[] copy = new int[256];
        boolean[] bigDone = new boolean[256];
        for (i = 0; i < 20; ++i) {
            this.blockBytes[this.count + i + 1] = this.blockBytes[i % this.count + 1];
        }
        for (i = 0; i <= this.count + 20; ++i) {
            this.quadrantShorts[i] = 0;
        }
        this.blockBytes[0] = this.blockBytes[this.count];
        if (this.count <= 4000) {
            for (i = 0; i < this.count; ++i) {
                this.zptr[i] = i;
            }
            this.firstAttempt = false;
            this.workLimit = 0;
            this.workDone = 0;
            this.simpleSort(0, this.count - 1, 0);
        } else {
            int j;
            int c2;
            for (i = 0; i <= 255; ++i) {
                bigDone[i] = false;
            }
            for (i = 0; i <= 65536; ++i) {
                this.ftab[i] = 0;
            }
            int c1 = this.blockBytes[0] & 0xFF;
            for (i = 0; i < this.count; ++i) {
                c2 = this.blockBytes[i + 1] & 0xFF;
                int n = (c1 << 8) + c2;
                this.ftab[n] = this.ftab[n] + 1;
                c1 = c2;
            }
            for (i = 1; i <= 65536; ++i) {
                int n = i;
                this.ftab[n] = this.ftab[n] + this.ftab[i - 1];
            }
            c1 = this.blockBytes[1] & 0xFF;
            i = 0;
            while (i < this.count - 1) {
                c2 = this.blockBytes[i + 2] & 0xFF;
                j = (c1 << 8) + c2;
                c1 = c2;
                int n = j;
                this.ftab[n] = this.ftab[n] - 1;
                this.zptr[this.ftab[j]] = i++;
            }
            int n = j = ((this.blockBytes[this.count] & 0xFF) << 8) + (this.blockBytes[1] & 0xFF);
            this.ftab[n] = this.ftab[n] - 1;
            this.zptr[this.ftab[j]] = this.count - 1;
            for (i = 0; i <= 255; ++i) {
                runningOrder[i] = i;
            }
            int h = 1;
            while ((h = 3 * h + 1) <= 256) {
            }
            do {
                for (i = h /= 3; i <= 255; ++i) {
                    int vv = runningOrder[i];
                    j = i;
                    while (this.ftab[runningOrder[j - h] + 1 << 8] - this.ftab[runningOrder[j - h] << 8] > this.ftab[vv + 1 << 8] - this.ftab[vv << 8]) {
                        runningOrder[j] = runningOrder[j - h];
                        if ((j -= h) > h - 1) continue;
                    }
                    runningOrder[j] = vv;
                }
            } while (h != 1);
            for (i = 0; i <= 255; ++i) {
                int ss = runningOrder[i];
                for (j = 0; j <= 255; ++j) {
                    int sb = (ss << 8) + j;
                    if ((this.ftab[sb] & 0x200000) == 0x200000) continue;
                    int hi = (this.ftab[sb + 1] & 0xFFDFFFFF) - 1;
                    int lo = this.ftab[sb] & 0xFFDFFFFF;
                    if (hi > lo) {
                        this.qSort3(lo, hi, 2);
                        if (this.workDone > this.workLimit && this.firstAttempt) {
                            return;
                        }
                    }
                    int n2 = sb;
                    this.ftab[n2] = this.ftab[n2] | 0x200000;
                }
                bigDone[ss] = true;
                if (i < 255) {
                    int bbStart = this.ftab[ss << 8] & 0xFFDFFFFF;
                    int bbSize = (this.ftab[ss + 1 << 8] & 0xFFDFFFFF) - bbStart;
                    int shifts = 0;
                    while (bbSize >> shifts > 65534) {
                        ++shifts;
                    }
                    for (j = 0; j < bbSize; ++j) {
                        short qVal;
                        int a2update = this.zptr[bbStart + j] + 1;
                        this.quadrantShorts[a2update] = qVal = (short)(j >> shifts);
                        if (a2update > 20) continue;
                        this.quadrantShorts[a2update + this.count] = qVal;
                    }
                    if (bbSize - 1 >> shifts > 65535) {
                        throw new IllegalStateException();
                    }
                }
                for (j = 0; j <= 255; ++j) {
                    copy[j] = this.ftab[(j << 8) + ss] & 0xFFDFFFFF;
                }
                for (j = this.ftab[ss << 8] & 0xFFDFFFFF; j < (this.ftab[ss + 1 << 8] & 0xFFDFFFFF); ++j) {
                    c1 = this.blockBytes[this.zptr[j]] & 0xFF;
                    if (bigDone[c1]) continue;
                    this.zptr[copy[c1]] = (this.zptr[j] == 0 ? this.count : this.zptr[j]) - 1;
                    int n3 = c1;
                    copy[n3] = copy[n3] + 1;
                }
                for (j = 0; j <= 255; ++j) {
                    int n4 = (j << 8) + ss;
                    this.ftab[n4] = this.ftab[n4] | 0x200000;
                }
            }
        }
    }

    private void randomiseBlock() {
        for (int i = 0; i < 256; ++i) {
            this.inUse[i] = false;
        }
        int rNToGo = 0;
        int rTPos = 0;
        for (int i = 1; i <= this.count; ++i) {
            if (rNToGo == 0) {
                rNToGo = R_NUMS[rTPos++];
                rTPos &= 0x1FF;
            }
            int n = i;
            this.blockBytes[n] = (byte)(this.blockBytes[n] ^ (--rNToGo == 1 ? (byte)1 : 0));
            this.inUse[this.blockBytes[i] & 0xFF] = true;
        }
    }

    private void doReversibleTransformation() {
        this.workLimit = this.workFactor * (this.count - 1);
        this.workDone = 0;
        this.blockRandomised = false;
        this.firstAttempt = true;
        this.mainSort();
        if (this.workDone > this.workLimit && this.firstAttempt) {
            this.randomiseBlock();
            this.workDone = 0;
            this.workLimit = 0;
            this.blockRandomised = true;
            this.firstAttempt = false;
            this.mainSort();
        }
        this.origPtr = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.zptr[i] != 0) continue;
            this.origPtr = i;
            break;
        }
        if (this.origPtr == -1) {
            throw new IllegalStateException();
        }
    }

    private boolean fullGtU(int i1, int i2) {
        int c2;
        int c1;
        if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
            return c1 > c2;
        }
        if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
            return c1 > c2;
        }
        if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
            return c1 > c2;
        }
        if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
            return c1 > c2;
        }
        if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
            return c1 > c2;
        }
        if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
            return c1 > c2;
        }
        int k = this.count;
        do {
            if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
                return c1 > c2;
            }
            int s1 = this.quadrantShorts[i1] & 0xFFFF;
            int s2 = this.quadrantShorts[i2] & 0xFFFF;
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
                return c1 > c2;
            }
            s1 = this.quadrantShorts[i1] & 0xFFFF;
            s2 = this.quadrantShorts[i2] & 0xFFFF;
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
                return c1 > c2;
            }
            s1 = this.quadrantShorts[i1] & 0xFFFF;
            s2 = this.quadrantShorts[i2] & 0xFFFF;
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
                return c1 > c2;
            }
            s1 = this.quadrantShorts[i1] & 0xFFFF;
            s2 = this.quadrantShorts[i2] & 0xFFFF;
            if (s1 != s2) {
                return s1 > s2;
            }
            if (i1 >= this.count) {
                i1 -= this.count;
            }
            if (i2 >= this.count) {
                i2 -= this.count;
            }
            ++this.workDone;
        } while ((k -= 4) >= 0);
        return false;
    }

    private void generateMTFValues() {
        int i;
        this.nInUse = 0;
        byte[] yy = new byte[256];
        for (i = 0; i < 256; ++i) {
            if (!this.inUse[i]) continue;
            yy[this.nInUse++] = (byte)i;
        }
        int EOB = this.nInUse + 1;
        for (i = 0; i <= EOB; ++i) {
            this.mtfFreq[i] = 0;
        }
        int wr = 0;
        int zPend = 0;
        for (i = 0; i < this.count; ++i) {
            byte blockByte = this.blockBytes[this.zptr[i]];
            byte tmp = yy[0];
            if (blockByte == tmp) {
                ++zPend;
                continue;
            }
            int sym = 1;
            do {
                byte tmp2 = tmp;
                tmp = yy[sym];
                yy[sym++] = tmp2;
            } while (blockByte != tmp);
            yy[0] = tmp;
            while (zPend > 0) {
                int run = --zPend & 1;
                this.szptr[wr++] = run;
                int n = run;
                this.mtfFreq[n] = this.mtfFreq[n] + 1;
                zPend >>>= 1;
            }
            this.szptr[wr++] = sym;
            int n = sym;
            this.mtfFreq[n] = this.mtfFreq[n] + 1;
        }
        while (zPend > 0) {
            int run = --zPend & 1;
            this.szptr[wr++] = run;
            int n = run;
            this.mtfFreq[n] = this.mtfFreq[n] + 1;
            zPend >>>= 1;
        }
        this.szptr[wr++] = EOB;
        int n = EOB;
        this.mtfFreq[n] = this.mtfFreq[n] + 1;
        this.nMTF = wr;
    }

    private static class StackElem {
        int ll;
        int hh;
        int dd;

        private StackElem() {
        }
    }
}

