/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cert.cmp;

import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.CMPCertificate;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.CertStatus;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.PKIStatusInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cert.cmp.CMPException;
import net.savignano.thirdparty.org.bouncycastle.cert.cmp.CMPUtil;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder certHolder, DigestCalculatorProvider digesterProvider) throws CMPException {
        return this.isVerified(new CMPCertificate(certHolder.toASN1Structure()), certHolder.getSignatureAlgorithm(), digesterProvider);
    }

    public boolean isVerified(CMPCertificate cmpCert, AlgorithmIdentifier signatureAlgorithm, DigestCalculatorProvider digesterProvider) throws CMPException {
        byte[] certHash = CMPUtil.calculateCertHash(cmpCert, signatureAlgorithm, digesterProvider, this.digestAlgFinder);
        return Arrays.constantTimeAreEqual(this.certStatus.getCertHash().getOctets(), certHash);
    }
}

