/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jcajce.provider.symmetric;

import net.savignano.thirdparty.org.bouncycastle.crypto.CipherKeyGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.engines.HC256Engine;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class HC256 {
    private HC256() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = HC256.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.HC256", PREFIX + "$Base");
            provider.addAlgorithm("KeyGenerator.HC256", PREFIX + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.HC256", PREFIX + "$AlgParams");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "HC256 IV";
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("HC256", 256, new CipherKeyGenerator());
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new HC256Engine(), 32);
        }
    }
}

