/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2;

import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;

public class HeaderInfoContributorId
extends ASN1Object {
    private final BigInteger contributorId;
    private static final BigInteger MAX = BigInteger.valueOf(255L);

    public HeaderInfoContributorId(long value) {
        this(BigInteger.valueOf(value));
    }

    public HeaderInfoContributorId(BigInteger value) {
        if (value.signum() < 0 && value.compareTo(MAX) > 0) {
            throw new IllegalArgumentException("contributor id " + value + " is out of range 0..255");
        }
        this.contributorId = value;
    }

    private HeaderInfoContributorId(ASN1Integer integer) {
        this(integer.getValue());
    }

    public static HeaderInfoContributorId getInstance(Object src) {
        if (src instanceof HeaderInfoContributorId) {
            return (HeaderInfoContributorId)src;
        }
        if (src != null) {
            return new HeaderInfoContributorId(ASN1Integer.getInstance(src));
        }
        return null;
    }

    public BigInteger getContributorId() {
        return this.contributorId;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new ASN1Integer(this.contributorId);
    }
}

