/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce;

import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.CMCEEngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.CMCEKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.CMCEParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.CMCEPrivateKeyParameters;

public class CMCEKEMExtractor
implements EncapsulatedSecretExtractor {
    private CMCEEngine engine;
    private CMCEKeyParameters key;

    public CMCEKEMExtractor(CMCEPrivateKeyParameters privParams) {
        this.key = privParams;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(CMCEParameters param) {
        this.engine = param.getEngine();
        CMCEPrivateKeyParameters privateParams = (CMCEPrivateKeyParameters)this.key;
        if (privateParams.getPrivateKey().length < this.engine.getPrivateKeySize()) {
            this.key = new CMCEPrivateKeyParameters(privateParams.getParameters(), this.engine.decompress_private_key(privateParams.getPrivateKey()));
        }
    }

    @Override
    public byte[] extractSecret(byte[] encapsulation) {
        return this.extractSecret(encapsulation, this.engine.getDefaultSessionKeySize());
    }

    public byte[] extractSecret(byte[] encapsulation, int sessionKeySizeInBits) {
        byte[] session_key = new byte[sessionKeySizeInBits / 8];
        this.engine.kem_dec(session_key, encapsulation, ((CMCEPrivateKeyParameters)this.key).getPrivateKey());
        return session_key;
    }

    @Override
    public int getEncapsulationLength() {
        return this.engine.getCipherTextSize();
    }
}

