/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.exceptions.JmapFieldNotSupportedException;
import org.apache.james.jmap.draft.methods.ErrorResponse;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapRequestParser;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.JmapResponseWriter;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.AuthenticatedRequest;
import org.apache.james.jmap.draft.model.InvocationResponse;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHandler.class);
    private final JmapRequestParser jmapRequestParser;
    private final JmapResponseWriter jmapResponseWriter;
    private final Map<Method.Request.Name, Method> methods;

    @Inject
    public RequestHandler(Set<Method> methods, JmapRequestParser jmapRequestParser, JmapResponseWriter jmapResponseWriter) {
        this.jmapRequestParser = jmapRequestParser;
        this.jmapResponseWriter = jmapResponseWriter;
        this.methods = methods.stream().collect(Collectors.toMap(Method::requestHandled, Function.identity()));
    }

    public Flux<InvocationResponse> handle(AuthenticatedRequest request) {
        Flux flux;
        block8: {
            Optional<MailboxSession> mailboxSession = Optional.ofNullable(request.getMailboxSession());
            Closeable closeable = MDCBuilder.create().addToContextIfPresent("user", mailboxSession.map(MailboxSession::getUser).map(Username::asString)).addToContextIfPresent("sessionId", mailboxSession.map(MailboxSession::getSessionId).map(MailboxSession.SessionId::getValue).map(l -> Long.toString(l))).addToContext("action", request.getMethodName().getName()).build();
            try {
                flux = Optional.ofNullable(this.methods.get(request.getMethodName())).map(this.extractAndProcess(request)).map(this.jmapResponseWriter::formatMethodResponse).orElseThrow(() -> new IllegalStateException("unknown method " + String.valueOf(request.getMethodName())));
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return flux;
    }

    private Function<Method, Flux<JmapResponse>> extractAndProcess(AuthenticatedRequest request) {
        MailboxSession mailboxSession = request.getMailboxSession();
        return method -> Mono.fromCallable(() -> this.jmapRequestParser.extractJmapRequest(request, method.requestType())).flatMapMany(jmapRequest -> method.process((JmapRequest)jmapRequest, request.getMethodCallId(), mailboxSession)).onErrorResume(JmapFieldNotSupportedException.class, e -> this.errorNotImplemented((JmapFieldNotSupportedException)((Object)((Object)e)), request)).onErrorResume(e -> e.getCause() instanceof JmapFieldNotSupportedException, e -> this.errorNotImplemented((JmapFieldNotSupportedException)((Object)((Object)((Object)e.getCause()))), request)).onErrorResume(IOException.class, e -> this.error(request, this.generateInvalidArgumentError(e.getMessage())));
    }

    public ErrorResponse generateInvalidArgumentError(String description) {
        return ErrorResponse.builder().type("invalidArguments").description(description).build();
    }

    private Flux<JmapResponse> errorNotImplemented(JmapFieldNotSupportedException error, AuthenticatedRequest request) {
        return Flux.just((Object)JmapResponse.builder().methodCallId(request.getMethodCallId()).error(this.generateInvalidArgumentError("The field '" + error.getField() + "' of '" + error.getIssuer() + "' is not supported")).build());
    }

    private Flux<JmapResponse> error(AuthenticatedRequest request, ErrorResponse error) {
        return Flux.just((Object)JmapResponse.builder().methodCallId(request.getMethodCallId()).error(error).build());
    }
}

