/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.james.jmap.draft.exceptions.MalformedContinuationTokenException;
import org.apache.james.jmap.draft.model.SignedExpiringToken;

public class ContinuationToken
implements SignedExpiringToken {
    public static final String SEPARATOR = "_";
    private final String username;
    private final ZonedDateTime expirationDate;
    private final String signature;

    public static Builder builder() {
        return new Builder();
    }

    public static ContinuationToken fromString(String serializedToken) throws MalformedContinuationTokenException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serializedToken) ? 1 : 0) != 0, (Object)"Serialized continuation token should not be null or empty");
        LinkedList tokenParts = Lists.newLinkedList((Iterable)Splitter.on((String)SEPARATOR).split((CharSequence)serializedToken));
        try {
            return ContinuationToken.builder().signature((String)tokenParts.removeLast()).expirationDate(ZonedDateTime.parse((CharSequence)tokenParts.removeLast(), DateTimeFormatter.ISO_OFFSET_DATE_TIME)).username(Joiner.on((String)SEPARATOR).join((Iterable)tokenParts)).build();
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            throw new MalformedContinuationTokenException("Token " + serializedToken + " does not have enough parts", e);
        }
        catch (DateTimeException e) {
            throw new MalformedContinuationTokenException("Token " + serializedToken + " as an incorrect date", e);
        }
    }

    public ContinuationToken(String username, ZonedDateTime expirationDate, String signature) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkArgument((!username.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)expirationDate);
        Preconditions.checkNotNull((Object)signature);
        this.username = username;
        this.expirationDate = expirationDate;
        this.signature = signature;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public ZonedDateTime getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    public String serialize() {
        return this.getPayload() + SEPARATOR + this.signature;
    }

    @Override
    public String getPayload() {
        return this.username + SEPARATOR + DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDate);
    }

    @Override
    public String getSignedContent() {
        return this.getPayload();
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ContinuationToken continuationToken = (ContinuationToken)other;
        return Objects.equals(this.username, continuationToken.username) && this.expirationDate.isEqual(continuationToken.expirationDate) && Objects.equals(this.signature, continuationToken.signature);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.expirationDate, this.signature);
    }

    public String toString() {
        return "ContinuationToken{username='" + this.username + "', expirationDate=" + String.valueOf(this.expirationDate) + ", signature='" + this.signature + "'}";
    }

    public static class Builder {
        private String username;
        private ZonedDateTime expirationDate;
        private String signature;

        private Builder() {
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder expirationDate(ZonedDateTime expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public ContinuationToken build() {
            return new ContinuationToken(this.username, this.expirationDate, this.signature);
        }
    }
}

