/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.utils;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.util.html.HtmlTextExtractor;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsoupHtmlTextExtractor
implements HtmlTextExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsoupHtmlTextExtractor.class);
    public static final String BR_TAG = "br";
    public static final String UL_TAG = "ul";
    public static final String OL_TAG = "ol";
    public static final String LI_TAG = "li";
    public static final String P_TAG = "p";
    public static final String IMG_TAG = "img";
    public static final String ALT_TAG = "alt";
    public static final int INITIAL_LIST_NESTED_LEVEL = 0;

    public String toPlainText(String html) {
        try {
            Document document = Jsoup.parse((String)html);
            Element body = Optional.ofNullable(document.body()).orElse((Element)document);
            return this.flatten((Node)body, 0).map(this::convertNodeToText).collect(Collectors.joining());
        }
        catch (Exception e) {
            LOGGER.warn("Failed extracting text from html", (Throwable)e);
            return html;
        }
    }

    private String convertNodeToText(HTMLNode htmlNode) {
        Node node = htmlNode.underlyingNode;
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            return textNode.getWholeText();
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            if (element.tagName().equals(BR_TAG)) {
                return "\n";
            }
            if (this.isList(element)) {
                return this.convertListElement(htmlNode.listNestedLevel);
            }
            if (element.tagName().equals(OL_TAG)) {
                return "\n\n";
            }
            if (element.tagName().equals(LI_TAG)) {
                return "\n" + StringUtils.repeat((String)" ", (int)htmlNode.listNestedLevel) + "- ";
            }
            if (element.tagName().equals(P_TAG)) {
                return "\n\n";
            }
            if (element.tagName().equals(IMG_TAG)) {
                return this.generateImageAlternativeText(element);
            }
        }
        return "";
    }

    private String generateImageAlternativeText(Element element) {
        return Optional.ofNullable(element.attributes().get(ALT_TAG)).map(StringUtils::normalizeSpace).filter(Predicate.not(Strings::isNullOrEmpty)).map(s -> "[" + s + "]").orElse("");
    }

    private String convertListElement(int nestedLevel) {
        if (nestedLevel == 0) {
            return "\n\n";
        }
        return "";
    }

    Stream<HTMLNode> flatten(Node base, int listNestedLevel) {
        Position position = this.getPosition(base);
        int nextElementLevel = this.getNewNestedLevel(listNestedLevel, base);
        Stream<HTMLNode> baseStream = Stream.of(new HTMLNode(base, listNestedLevel));
        Stream flatChildren = base.childNodes().stream().flatMap(node -> this.flatten((Node)node, nextElementLevel));
        switch (position) {
            case PREFIX: {
                return Stream.concat(baseStream, flatChildren);
            }
            case SUFFIX: {
                return Stream.concat(flatChildren, baseStream);
            }
        }
        throw new RuntimeException("Unexpected POSITION for node element: " + String.valueOf((Object)position));
    }

    private int getNewNestedLevel(int listNestedLevel, Node node) {
        Element element;
        if (node instanceof Element && this.isList(element = (Element)node)) {
            return listNestedLevel + 1;
        }
        return listNestedLevel;
    }

    private boolean isList(Element element) {
        return element.tagName().equals(UL_TAG) || element.tagName().equals(OL_TAG);
    }

    private Position getPosition(Node node) {
        Element element;
        if (node instanceof Element && (element = (Element)node).tagName().equals(LI_TAG)) {
            return Position.PREFIX;
        }
        return Position.SUFFIX;
    }

    private static class HTMLNode {
        private final Node underlyingNode;
        private final int listNestedLevel;

        public HTMLNode(Node underlyingNode, int listNestedLevel) {
            this.underlyingNode = underlyingNode;
            this.listNestedLevel = listNestedLevel;
        }
    }

    private static enum Position {
        PREFIX,
        SUFFIX;

    }
}

