/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mailet.filter;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.mailet.filter.ContentMatcher;
import org.apache.james.jmap.mailet.filter.HeaderExtractor;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MailMatcher {
    public static MailMatcher from(Rule rule) {
        Rule.Condition ruleCondition = rule.getCondition();
        Optional<ContentMatcher> maybeContentMatcher = ContentMatcher.asContentMatcher(ruleCondition.getField(), ruleCondition.getComparator());
        Optional<HeaderExtractor> maybeHeaderExtractor = HeaderExtractor.asHeaderExtractor(ruleCondition.getField());
        return new HeaderMatcher(maybeContentMatcher.orElseThrow(() -> new RuntimeException("No content matcher associated with field " + String.valueOf(ruleCondition.getField()))), rule.getCondition().getValue(), maybeHeaderExtractor.orElseThrow(() -> new RuntimeException("No content matcher associated with comparator " + String.valueOf(ruleCondition.getComparator()))));
    }

    public boolean match(Mail var1);

    public static class HeaderMatcher
    implements MailMatcher {
        private static final Logger LOGGER = LoggerFactory.getLogger(HeaderMatcher.class);
        private final ContentMatcher contentMatcher;
        private final String ruleValue;
        private final HeaderExtractor headerExtractor;

        private HeaderMatcher(ContentMatcher contentMatcher, String ruleValue, HeaderExtractor headerExtractor) {
            Preconditions.checkNotNull((Object)contentMatcher);
            Preconditions.checkNotNull((Object)headerExtractor);
            this.contentMatcher = contentMatcher;
            this.ruleValue = ruleValue;
            this.headerExtractor = headerExtractor;
        }

        @Override
        public boolean match(Mail mail) {
            try {
                Stream headerLines = (Stream)this.headerExtractor.apply(mail);
                return this.contentMatcher.match(headerLines, this.ruleValue);
            }
            catch (Exception e) {
                LOGGER.error("error while extracting mail header", (Throwable)e);
                return false;
            }
        }
    }
}

