/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.base.handler.incoming;

import net.savignano.uptrust.proxy.base.handler.incoming.IncomingMailHandler;
import net.savignano.uptrust.proxy.base.handler.incoming.IncomingMailHandlerConfiguration;
import net.savignano.uptrust.service.cryptography.IDecryptionService;
import net.savignano.uptrust.service.cryptography.IExtractionService;
import net.savignano.uptrust.service.cryptography.IValidationService;
import net.savignano.uptrust.service.decorator.IDecoratorService;
import net.savignano.uptrust.service.key.IKeyService;
import net.savignano.uptrust.service.license.ILicenseService;
import org.apache.commons.configuration2.ImmutableConfiguration;

public class IncomingMailHandlerBuilder {
    private static final String CHECK_TRUST_KEY = "checkTrust";
    private static final String SERVER_SIDE_PROTECTION_HANDLING_KEY = "serverSideProtectionHandling";
    private final IncomingMailHandlerConfiguration config = new IncomingMailHandlerConfiguration();

    public static IncomingMailHandlerBuilder empty() {
        return new IncomingMailHandlerBuilder();
    }

    public static IncomingMailHandlerBuilder from(ImmutableConfiguration config) {
        IncomingMailHandlerBuilder builder = IncomingMailHandlerBuilder.empty();
        builder.checkTrust(config.getBoolean(CHECK_TRUST_KEY, true));
        builder.clientSupportsProtection(!config.getBoolean(SERVER_SIDE_PROTECTION_HANDLING_KEY, true));
        return builder;
    }

    private IncomingMailHandlerBuilder() {
    }

    public IncomingMailHandler build() {
        return new IncomingMailHandler(new IncomingMailHandlerConfiguration(this.config));
    }

    public IncomingMailHandlerBuilder checkLicenseWith(ILicenseService service) {
        this.config.setLicenseService(service);
        return this;
    }

    public IncomingMailHandlerBuilder decryptWith(IDecryptionService service) {
        this.config.setDecryptionService(service);
        return this;
    }

    public IncomingMailHandlerBuilder validateWith(IValidationService service) {
        this.config.setValidationService(service);
        return this;
    }

    public IncomingMailHandlerBuilder extractWith(IExtractionService service) {
        this.config.setExtractionService(service);
        return this;
    }

    public IncomingMailHandlerBuilder decorateWith(IDecoratorService service) {
        this.config.setDecoratorService(service);
        return this;
    }

    public IncomingMailHandlerBuilder keyService(IKeyService service) {
        this.config.setKeyService(service);
        return this;
    }

    public IncomingMailHandlerBuilder checkTrust(boolean checkTrust) {
        this.config.setCheckTrust(checkTrust);
        return this;
    }

    public IncomingMailHandlerBuilder clientSupportsProtection(boolean supports) {
        this.config.setClientSupportsProtection(supports);
        return this;
    }
}

