/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.base.handler.outgoing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.uptrust.proxy.base.handler.EProtectionFailureBehaviour;
import net.savignano.uptrust.proxy.base.handler.IComplexMailHandler;
import net.savignano.uptrust.proxy.base.handler.outgoing.OutgoingMailHandlerConfiguration;
import net.savignano.uptrust.service.EResult;
import net.savignano.uptrust.service.cryptography.IEncryptionService;
import net.savignano.uptrust.service.cryptography.ISigningService;
import net.savignano.uptrust.service.cryptography.config.CryptographyServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutgoingMailHandler
implements IComplexMailHandler {
    public static final String RELEVANT_ADDRESSES_CONTEXT_KEY = "relevantAddresses";
    public static final String MESSAGE_RESULT_KEY = "message";
    public static final String ADDRESSES_RESULT_KEY = "addresses";
    public static final String OUTCOME_RESULT_KEY = "outcome";
    public static final String CRYPTOGRAPHY_RESULT_KEY = "cryptography";
    private static final Logger LOG = LoggerFactory.getLogger(OutgoingMailHandler.class);
    private static final String ENCRYPTION_ERROR_HEADER = "X-EncryptionError";
    private static final String SIGNING_ERROR_HEADER = "X-SigningError";
    private final OutgoingMailHandlerConfiguration config;

    public OutgoingMailHandler(OutgoingMailHandlerConfiguration config) {
        this.config = config;
        if (config == null) {
            throw new NullPointerException("Configuration must not be null.");
        }
    }

    @Override
    public List<Map<String, Object>> handleMessage(MimeMessage msg, Map<String, Object> context) {
        String msgId = MessageUtil.getMessageId((Message)msg);
        LOG.debug("Handling outgoing message with ID \"{}\".", (Object)msgId);
        LOG.trace("Context for message handling: {}", context);
        Collection relevantAddresses = (Collection)context.get(RELEVANT_ADDRESSES_CONTEXT_KEY);
        if (!this.config.getLicenseService().isValid()) {
            LOG.error("No valid license configured. Message with ID \"{}\" will not be cryptographically processed.", (Object)msgId);
            return Collections.singletonList(this.createResult(msg, ECryptographyType.NONE, EResult.FAILURE, relevantAddresses));
        }
        Function<MimeMessage, ECryptographyType> detectCryptoFunc = this.config.getDetectCryptoFunc();
        if (detectCryptoFunc == null) {
            LOG.error("Cannot determine cryptography of message. Uptrust not correctly configured. Cannot protect message.");
            return Collections.singletonList(this.createResult(msg, ECryptographyType.NONE, EResult.FAILURE, relevantAddresses));
        }
        ECryptographyType cryptography = detectCryptoFunc.apply(msg);
        List<Map<String, Object>> result = cryptography != ECryptographyType.NONE ? (this.config.getEncryptedPred().test(msg) ? this.handleProtected(msg, msgId, cryptography, relevantAddresses) : this.handleNeedsEncryption(msg, msgId, cryptography, relevantAddresses)) : this.handleUnprotected(msg, msgId, relevantAddresses);
        for (Map<String, Object> map : result) {
            MimeMessage createdMsg = (MimeMessage)map.get(MESSAGE_RESULT_KEY);
            if (msgId.equals(MessageUtil.getMessageId((Message)createdMsg))) continue;
            try {
                createdMsg.setHeader("Message-ID", msgId);
            }
            catch (MessagingException e) {
                LOG.error("Could not reset message ID for message with sequence number: " + createdMsg.getMessageNumber(), (Throwable)e);
            }
        }
        return result;
    }

    private List<Map<String, Object>> handleProtected(MimeMessage msg, String msgId, ECryptographyType cryptography, Collection<Address> relevantAddresses) {
        LOG.info("Message with ID \"{}\" already protected.", (Object)msgId);
        return Collections.singletonList(this.createResult(msg, cryptography, EResult.SUCCESS, relevantAddresses));
    }

    private List<Map<String, Object>> handleNeedsEncryption(MimeMessage msg, String msgId, ECryptographyType cryptography, Collection<Address> relevantAddresses) {
        LOG.info("Message with ID \"{}\" needs additional encryption.", (Object)msgId);
        IEncryptionService.EncryptionResult encResult = this.encrypt(msg, this.copy(msg), cryptography, relevantAddresses);
        LOG.debug("Result of encrypting message with ID \"{}\": {}", (Object)msgId, (Object)encResult);
        if (encResult.isSuccess()) {
            this.overwrite(encResult.getMessage(), msg);
        }
        CryptoResult result = new CryptoResult();
        result.encResult = encResult;
        result.primaryMsg = msg;
        return this.map(result);
    }

    private List<Map<String, Object>> handleUnprotected(MimeMessage msg, String msgId, Collection<Address> relevantAddresses) {
        CryptographyServiceConfiguration.ECryptographyUsage cryptoUsage = this.config.getCryptographicUsage();
        LOG.info("Protecting message with ID \"{}\" with: {}", (Object)msgId, (Object)cryptoUsage);
        CryptoResult result = switch (cryptoUsage) {
            case CryptographyServiceConfiguration.ECryptographyUsage.PGP_ONLY, CryptographyServiceConfiguration.ECryptographyUsage.SMIME_ONLY -> this.handleMsg(msg, cryptoUsage.getCryptography(), relevantAddresses);
            case CryptographyServiceConfiguration.ECryptographyUsage.PGP_PREFERRED, CryptographyServiceConfiguration.ECryptographyUsage.SMIME_PREFERRED -> {
                Function<MimeMessage, CryptoResult> preferred = m -> this.handleMsg((MimeMessage)m, cryptoUsage.getCryptography(), relevantAddresses);
                Function<MimeMessage, CryptoResult> fallback = m -> this.handleMsg((MimeMessage)m, cryptoUsage.getFallbackCryptography(), relevantAddresses);
                yield this.handleWithFallback(msg, preferred, fallback);
            }
            default -> {
                LOG.error("Unknown cryptographic usage encountered. Using default SMIME_PREFERRED to continue. Encountered usage: {}", (Object)cryptoUsage);
                yield this.handleWithFallback(msg, m -> this.handleMsg((MimeMessage)m, ECryptographyType.SMIME, relevantAddresses), m -> this.handleMsg((MimeMessage)m, ECryptographyType.PGP, relevantAddresses));
            }
        };
        return this.map(result);
    }

    private CryptoResult handleMsg(MimeMessage msg, ECryptographyType cryptography, Collection<Address> relevantAddresses) {
        String msgId = MessageUtil.getMessageId((Message)msg);
        CryptoResult result = new CryptoResult();
        result.primaryMsg = this.copy(msg);
        result.signResult = this.sign(msg, result.primaryMsg, cryptography);
        LOG.debug("Result of signing message with ID \"{}\": {}", (Object)msgId, (Object)result.signResult);
        this.overwrite(msg, result.primaryMsg);
        result.encResult = this.encrypt(msg, result.primaryMsg, cryptography, relevantAddresses);
        LOG.debug("Result of encrypting message with ID \"{}\": {}", (Object)msgId, (Object)result.encResult);
        if (result.encResult.isSuccess()) {
            this.overwrite(result.encResult.getMessage(), result.primaryMsg);
        }
        return result;
    }

    private IEncryptionService.EncryptionResult encrypt(MimeMessage msg, MimeMessage safetyMsg, ECryptographyType cryptography, Collection<Address> addresses) {
        if (this.config.getEncryptionService() == null) {
            IEncryptionService.EncryptionResult result = new IEncryptionService.EncryptionResult();
            result.setMessage(msg);
            result.getValidity().put(EKeyValidity.VALID, addresses);
            return result;
        }
        String msgId = MessageUtil.getMessageId((Message)msg);
        IEncryptionService.EncryptionResult result = this.config.getEncryptionService().encrypt(msg, cryptography, addresses);
        LOG.debug("Encryption result for message with ID \"{}\": {}", (Object)msgId, (Object)result);
        if (result.getException() != null) {
            this.overwrite(safetyMsg, msg);
            try {
                MessageUtil.setHeader((Message)msg, (String)ENCRYPTION_ERROR_HEADER, (String)"Could not encrypt message. Error message: {0}", (Object[])new Object[]{result.getException().getMessage()});
            }
            catch (MessagingException e) {
                LOG.error("Could not set encryption error header in message with ID \"" + MessageUtil.getMessageId((Message)msg) + "\". Error message: " + e.getMessage(), (Throwable)e);
            }
        } else if (result.getMessage() != msg) {
            this.overwrite(result.getMessage(), msg);
        }
        return result;
    }

    private ISigningService.SigningResult sign(MimeMessage msg, MimeMessage safetyMsg, ECryptographyType cryptography) {
        if (this.config.getSigningService() == null) {
            ISigningService.SigningResult result = new ISigningService.SigningResult();
            result.setMessage(msg);
            return result;
        }
        String msgId = MessageUtil.getMessageId((Message)msg);
        ISigningService.SigningResult result = this.config.getSigningService().sign(msg, cryptography);
        LOG.debug("Signing result for message with ID \"{}\": {}", (Object)msgId, (Object)result);
        if (result.getException() != null) {
            this.overwrite(safetyMsg, msg);
            try {
                MessageUtil.setHeader((Message)msg, (String)SIGNING_ERROR_HEADER, (String)"Could not sign message. Error message: {0}", (Object[])new Object[]{result.getException().getMessage()});
            }
            catch (MessagingException e) {
                LOG.error("Could not set signing error header in message with ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
            }
        } else if (result.getMessage() != msg) {
            this.overwrite(result.getMessage(), msg);
        }
        return result;
    }

    private CryptoResult handleWithFallback(MimeMessage msg, Function<MimeMessage, CryptoResult> preferred, Function<MimeMessage, CryptoResult> fallback) {
        int fallbackSuccess;
        MimeMessage fallbackMsg;
        try {
            fallbackMsg = MessageUtil.copyMsg((MimeMessage)msg);
        }
        catch (Exception e) {
            LOG.warn("Could not create copy of message with ID \"" + MessageUtil.getMessageId((Message)msg) + ". Cannot try fallback option. Error message: " + e.getMessage(), (Throwable)e);
            return preferred.apply(msg);
        }
        CryptoResult preferredResult = preferred.apply(msg);
        if (preferredResult.signResult.isSuccess() && preferredResult.encResult.isSuccess()) {
            return preferredResult;
        }
        CryptoResult fallbackResult = fallback.apply(fallbackMsg);
        int preferredSuccess = (preferredResult.encResult.isSuccess() ? 1 : 0) + (preferredResult.signResult.isSuccess() ? 1 : 0);
        if (preferredSuccess >= (fallbackSuccess = (fallbackResult.encResult.isSuccess() ? 1 : 0) + (fallbackResult.signResult.isSuccess() ? 1 : 0))) {
            return preferredResult;
        }
        try {
            MessageUtil.overwriteMsg((MimeMessage)fallbackMsg, (MimeMessage)msg);
        }
        catch (Exception e) {
            LOG.error("Failure to use non-preferred protection even though it succeeded, because original message with ID \"" + MessageUtil.getMessageId((Message)msg) + "\" could not be overwritten. Error message: " + e.getMessage(), (Throwable)e);
        }
        return fallbackResult;
    }

    private List<Map<String, Object>> map(CryptoResult result) {
        ArrayList<Map<String, Object>> mapped = new ArrayList<Map<String, Object>>(2);
        HashMap<String, Object> primaryResult = new HashMap<String, Object>();
        mapped.add(primaryResult);
        IEncryptionService.EncryptionResult encResult = result.encResult;
        primaryResult.put(CRYPTOGRAPHY_RESULT_KEY, encResult.getCryptography());
        primaryResult.put(MESSAGE_RESULT_KEY, result.primaryMsg);
        if (encResult.getValidity().size() == 1) {
            Map.Entry entry = encResult.getValidity().entrySet().iterator().next();
            primaryResult.put(OUTCOME_RESULT_KEY, entry.getKey() == EKeyValidity.VALID ? EResult.SUCCESS : EResult.FAILURE);
            primaryResult.put(ADDRESSES_RESULT_KEY, entry.getValue());
        } else {
            for (Map.Entry entry : encResult.getValidity().entrySet()) {
                EResult outcome;
                EResult eResult = outcome = entry.getKey() == EKeyValidity.VALID ? EResult.SUCCESS : EResult.FAILURE;
                if (entry.getKey() == EKeyValidity.VALID) {
                    HashMap<String, Object> validResult = new HashMap<String, Object>();
                    mapped.add(validResult);
                    validResult.put(CRYPTOGRAPHY_RESULT_KEY, encResult.getCryptography());
                    validResult.put(MESSAGE_RESULT_KEY, encResult.getMessage());
                    validResult.put(OUTCOME_RESULT_KEY, outcome);
                    validResult.put(ADDRESSES_RESULT_KEY, entry.getValue());
                    continue;
                }
                primaryResult.putIfAbsent(OUTCOME_RESULT_KEY, outcome);
                primaryResult.merge(ADDRESSES_RESULT_KEY, entry.getValue(), (c1, c2) -> {
                    ArrayList combined = new ArrayList((Collection)c1);
                    combined.addAll((Collection)c2);
                    return combined;
                });
            }
        }
        if (this.config.getFailureBehaviour() == EProtectionFailureBehaviour.ABORT) {
            Iterator iter = mapped.iterator();
            while (iter.hasNext()) {
                Map map = (Map)iter.next();
                if (map.get(OUTCOME_RESULT_KEY) == EResult.SUCCESS) continue;
                LOG.info("Could not encrypt email for participant(s) {}. Email will not be send.", map.get(ADDRESSES_RESULT_KEY));
                iter.remove();
            }
        }
        return mapped;
    }

    private MimeMessage copy(MimeMessage msg) {
        try {
            return MessageUtil.copyMsg((MimeMessage)msg);
        }
        catch (Exception e) {
            LOG.error("Could not create safety copy of message with ID: " + MessageUtil.getMessageId((Message)msg), (Throwable)e);
            return msg;
        }
    }

    private void overwrite(MimeMessage source, MimeMessage destination) {
        try {
            MessageUtil.overwriteMsg((MimeMessage)source, (MimeMessage)destination);
        }
        catch (Exception e) {
            LOG.error("Could not overwrite message with ID: " + MessageUtil.getMessageId((Message)destination), (Throwable)e);
        }
    }

    private Map<String, Object> createResult(MimeMessage msg, ECryptographyType cryptography, EResult outcome, Collection<Address> addresses) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(MESSAGE_RESULT_KEY, msg);
        result.put(CRYPTOGRAPHY_RESULT_KEY, cryptography);
        result.put(OUTCOME_RESULT_KEY, outcome);
        result.put(ADDRESSES_RESULT_KEY, addresses);
        return result;
    }

    private static final class CryptoResult {
        public IEncryptionService.EncryptionResult encResult;
        public ISigningService.SigningResult signResult;
        public MimeMessage primaryMsg;

        private CryptoResult() {
        }
    }
}

