/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.base.handler.outgoing;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.uptrust.proxy.base.handler.EProtectionFailureBehaviour;
import net.savignano.uptrust.proxy.base.handler.outgoing.OutgoingMailHandler;
import net.savignano.uptrust.proxy.base.handler.outgoing.OutgoingMailHandlerConfiguration;
import net.savignano.uptrust.service.config.converter.EnumConverter;
import net.savignano.uptrust.service.cryptography.IEncryptionService;
import net.savignano.uptrust.service.cryptography.ISigningService;
import net.savignano.uptrust.service.cryptography.config.CryptographyServiceConfiguration;
import net.savignano.uptrust.service.license.ILicenseService;
import org.apache.commons.configuration2.ImmutableConfiguration;

public class OutgoingMailHandlerBuilder {
    private static final String CRYPTOGRPAHIC_USAGE_KEY = "protection";
    private static final String FAILURE_BEHAVIOUR_USAGE_KEY = "protectionFailureBehaviour";
    private final OutgoingMailHandlerConfiguration config = new OutgoingMailHandlerConfiguration();

    public static OutgoingMailHandlerBuilder empty() {
        return new OutgoingMailHandlerBuilder().cryptographicUsage(CryptographyServiceConfiguration.ECryptographyUsage.SMIME_PREFERRED).failureBehaviour(EProtectionFailureBehaviour.CONTINUE);
    }

    public static OutgoingMailHandlerBuilder from(ImmutableConfiguration config) {
        CryptographyServiceConfiguration.ECryptographyUsage cryptoUsage = (CryptographyServiceConfiguration.ECryptographyUsage)((EnumConverter)new EnumConverter(CryptographyServiceConfiguration.ECryptographyUsage.class).from(config, CRYPTOGRPAHIC_USAGE_KEY)).get((Object)CryptographyServiceConfiguration.ECryptographyUsage.SMIME_PREFERRED);
        EProtectionFailureBehaviour failureBehaviour = (EProtectionFailureBehaviour)((Object)((EnumConverter)new EnumConverter(EProtectionFailureBehaviour.class).from(config, FAILURE_BEHAVIOUR_USAGE_KEY)).get((Object)EProtectionFailureBehaviour.CONTINUE));
        return OutgoingMailHandlerBuilder.empty().cryptographicUsage(cryptoUsage).failureBehaviour(failureBehaviour);
    }

    private OutgoingMailHandlerBuilder() {
    }

    public OutgoingMailHandler build() {
        return new OutgoingMailHandler(new OutgoingMailHandlerConfiguration(this.config));
    }

    public OutgoingMailHandlerBuilder cryptographicUsage(CryptographyServiceConfiguration.ECryptographyUsage usage) {
        this.config.setCryptographicUsage(usage);
        return this;
    }

    public OutgoingMailHandlerBuilder failureBehaviour(EProtectionFailureBehaviour failure) {
        this.config.setFailureBehaviour(failure);
        return this;
    }

    public OutgoingMailHandlerBuilder checkLicenseWith(ILicenseService service) {
        this.config.setLicenseService(service);
        return this;
    }

    public OutgoingMailHandlerBuilder encryptWith(IEncryptionService service) {
        this.config.setEncryptionService(service);
        return this;
    }

    public OutgoingMailHandlerBuilder signWith(ISigningService service) {
        this.config.setSigningService(service);
        return this;
    }

    public OutgoingMailHandlerBuilder detectCrypto(Function<MimeMessage, ECryptographyType> function) {
        this.config.setDetectCryptoFunc(function);
        return this;
    }

    public OutgoingMailHandlerBuilder detectEncryption(Predicate<MimeMessage> predicate) {
        this.config.setEncryptedPred(predicate);
        return this;
    }
}

