/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.base.proxy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.savignano.uptrust.proxy.base.proxy.ETransportSecurity;
import net.savignano.uptrust.proxy.base.proxy.IProxy;
import net.savignano.uptrust.proxy.base.request.BaseProxyRequest;
import net.savignano.uptrust.proxy.base.response.BaseProxyResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseProxy<T extends BaseProxyRequest, U extends BaseProxyResponse>
implements IProxy<T, U> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InetSocketAddress address;
    private ETransportSecurity transportSecurity = ETransportSecurity.NONE;
    private Socket socket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private volatile boolean sslHandshakeFinished;

    public BaseProxy(InetSocketAddress address) {
        this.address = address;
    }

    @Override
    public U connect() throws IOException, UnknownHostException {
        if (this.socket != null && this.socket.isConnected()) {
            return null;
        }
        this.log.debug("Using transport security: {}", (Object)this.getTransportSecurity());
        if (this.getTransportSecurity() == ETransportSecurity.TLS) {
            this.socket = this.createSslSocket();
            this.sslHandshake((SSLSocket)this.socket);
        } else {
            this.socket = this.createSocket();
        }
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.US_ASCII));
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), StandardCharsets.US_ASCII));
        String greeting = this.reader.readLine();
        this.log.debug("Server greeting: {}", (Object)greeting);
        if (this.getTransportSecurity() == ETransportSecurity.START_TLS && StringUtils.startsWithIgnoreCase((CharSequence)greeting, (CharSequence)"* OK")) {
            this.startTls();
            this.socket = this.upgradeToSslSocket(this.socket);
            this.sslHandshake((SSLSocket)this.socket);
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.US_ASCII));
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), StandardCharsets.US_ASCII));
        }
        return this.toResponse(new BaseProxyResponse(greeting));
    }

    @Override
    public U send(T request) throws IOException {
        if (request == null || ((BaseProxyRequest)request).getTransferData() == null) {
            throw new IOException("Null line.");
        }
        if (this.socket == null || !this.socket.isConnected()) {
            throw new IOException("Socket not connected.");
        }
        if (this.socket.isClosed()) {
            throw new IOException("Socket is closed.");
        }
        this.write(request);
        if (((BaseProxyRequest)request).isExpectingServerData()) {
            return this.toResponse(this.read(request));
        }
        return this.toResponse(BaseProxyResponse.NO_RESPONSE);
    }

    @Override
    public void close() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.socket = null;
        this.reader = null;
        this.writer = null;
    }

    @Override
    public boolean isReady() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    protected abstract U toResponse(BaseProxyResponse var1);

    protected abstract boolean isExpectMoreLines(String var1, T var2);

    protected abstract void startTls() throws IOException;

    private Socket createSocket() throws IOException {
        Socket plainSocket = SocketFactory.getDefault().createSocket(this.address.getAddress(), this.address.getPort());
        plainSocket.setSoTimeout(10000);
        plainSocket.setSoLinger(true, 1000);
        return plainSocket;
    }

    private SSLSocket createSslSocket() throws IOException {
        SSLSocket sslSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(this.address.getAddress(), this.address.getPort());
        sslSocket.setSoTimeout(10000);
        sslSocket.setSoLinger(true, 1000);
        return sslSocket;
    }

    private SSLSocket upgradeToSslSocket(Socket socket) throws IOException {
        SSLSocket sslSocket = (SSLSocket)((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(socket, null, true);
        sslSocket.setSoTimeout(10000);
        sslSocket.setSoLinger(true, 1000);
        return sslSocket;
    }

    private void sslHandshake(SSLSocket socket) throws IOException {
        this.log.debug("Starting SSL handshake.");
        socket.addHandshakeCompletedListener(e -> {
            this.sslHandshakeFinished = true;
        });
        socket.setUseClientMode(true);
        socket.startHandshake();
        this.log.debug("Waiting for SSL handshake to finish.");
        int timeout = 10000;
        while (!this.sslHandshakeFinished && timeout > 0) {
            try {
                Thread.sleep(100L);
                timeout -= 100;
            }
            catch (InterruptedException e1) {
                timeout = 0;
            }
        }
        if (timeout <= 0) {
            throw new IOException("SSL handshake timeout.");
        }
        this.log.debug("SSL handshake finished.");
    }

    protected void write(T request) throws IOException {
        String data = ((BaseProxyRequest)request).getTransferData();
        this.log.trace("Writing to {}: \"{}\"", (Object)this.getAddress(), (Object)data);
        this.writer.write(data);
        if (!((BaseProxyRequest)request).isLiteralData()) {
            this.log.trace("Writing crlf.");
            this.writer.append("\r\n");
        }
        this.writer.flush();
    }

    protected BaseProxyResponse read(T request) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        do {
            line = this.reader.readLine();
            this.log.trace("Read from {}: {}", (Object)this.getAddress(), (Object)line);
            if (line == null) {
                this.log.warn("Expected more data, but did not receive it. Request: {}", request);
                break;
            }
            lines.add(line);
        } while (this.isExpectMoreLines(line, request));
        this.log.trace("No more lines expected.");
        return new BaseProxyResponse(lines.toArray(new String[lines.size()]));
    }

    public ETransportSecurity getTransportSecurity() {
        return this.transportSecurity;
    }

    public void setTransportSecurity(ETransportSecurity transportSecurity) {
        this.transportSecurity = transportSecurity;
    }

    @Override
    public SocketAddress getAddress() {
        return this.address;
    }

    protected final Logger getLog() {
        return this.log;
    }

    protected final BufferedReader getReader() {
        return this.reader;
    }

    protected final BufferedWriter getWriter() {
        return this.writer;
    }
}

