/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.filesystem.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

public interface FileSystem {
    public static final String FILE_PROTOCOL = "file://";
    public static final String FILE_PROTOCOL_ABSOLUTE = "file:///";
    public static final String FILE_PROTOCOL_AND_CONF = "file://conf/";
    public static final String FILE_PROTOCOL_AND_VAR = "file://var/";
    public static final String CLASSPATH_PROTOCOL = "classpath:";
    public static final String URL_PROTOCOL = "url:";

    public InputStream getResource(String var1) throws IOException;

    public File getFile(String var1) throws FileNotFoundException;

    default public File getFileWithinBaseDir(String fileURL) throws FileNotFoundException, IOException {
        Path path = this.getFile(fileURL).toPath().normalize();
        if (path.startsWith(this.getBasedir().toPath().normalize())) {
            return path.toFile();
        }
        throw new IOException(fileURL + " -> " + path.toFile().getCanonicalPath() + " jail break outside of " + this.getBasedir().getCanonicalPath());
    }

    public File getBasedir() throws FileNotFoundException;
}

