/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ANONYMOUSBindRequest
extends SASLBindRequest {
    @NotNull
    public static final String ANONYMOUS_MECHANISM_NAME = "ANONYMOUS";
    private static final long serialVersionUID = 4259102841471750866L;
    @Nullable
    private final String traceString;

    public ANONYMOUSBindRequest() {
        this((String)null, NO_CONTROLS);
    }

    public ANONYMOUSBindRequest(@Nullable String traceString) {
        this(traceString, NO_CONTROLS);
    }

    public ANONYMOUSBindRequest(Control ... controls) {
        this((String)null, controls);
    }

    public ANONYMOUSBindRequest(@Nullable String traceString, Control ... controls) {
        super(controls);
        this.traceString = traceString;
    }

    @Override
    @NotNull
    public String getSASLMechanismName() {
        return ANONYMOUS_MECHANISM_NAME;
    }

    @Nullable
    public String getTraceString() {
        return this.traceString;
    }

    @Override
    @NotNull
    protected BindResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ASN1OctetString credentials = null;
        if (this.traceString != null && !this.traceString.isEmpty()) {
            credentials = new ASN1OctetString(this.traceString);
        }
        return this.sendBindRequest(connection, null, credentials, this.getControls(), this.getResponseTimeoutMillis(connection));
    }

    @Override
    @NotNull
    public ANONYMOUSBindRequest getRebindRequest(@NotNull String host, int port) {
        return new ANONYMOUSBindRequest(this.traceString, this.getControls());
    }

    @Override
    @NotNull
    public ANONYMOUSBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public ANONYMOUSBindRequest duplicate(@Nullable Control[] controls) {
        ANONYMOUSBindRequest bindRequest = new ANONYMOUSBindRequest(this.traceString, controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return bindRequest;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] controls;
        buffer.append("ANONYMOUSBindRequest(");
        if (this.traceString != null) {
            buffer.append(", trace='");
            buffer.append(this.traceString);
            buffer.append('\'');
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    @Override
    public void toCode(@NotNull List<String> lineList, @NotNull String requestID, int indentSpaces, boolean includeProcessing) {
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(2);
        constructorArgs.add(ToCodeArgHelper.createString(this.traceString, "Trace String"));
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            constructorArgs.add(ToCodeArgHelper.createControlArray(controls, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "ANONYMOUSBindRequest", requestID + "Request", "new ANONYMOUSBindRequest", constructorArgs);
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  BindResult " + requestID + "Result = connection.bind(" + requestID + "Request);");
            lineList.add(indent + "  // The bind was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The bind failed.  Maybe the following will " + "help explain why.");
            lineList.add(indent + "  // Note that the connection is now likely in " + "an unauthenticated state.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = " + "e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

