/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import java.io.Serializable;
import java.util.Locale;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailAddress
implements Serializable {
    public static final long serialVersionUID = 2779163542539434916L;
    private static final char[] SPECIAL = new char[]{'<', '>', '(', ')', '[', ']', '\\', '.', ',', ';', ':', '@', '\"'};
    private String localPart = null;
    private String domain = null;
    private int pos = 0;

    private void stripSourceRoute(String address) {
        int i;
        if (this.pos < address.length() && address.charAt(this.pos) == '@' && (i = address.indexOf(58)) != -1) {
            this.pos = i + 1;
        }
    }

    public MailAddress(String address) throws AddressException {
        address = address.trim();
        this.stripSourceRoute(address);
        StringBuffer localPartSB = new StringBuffer();
        StringBuffer domainSB = new StringBuffer();
        try {
            if (address.charAt(this.pos) == '\"') {
                localPartSB.append(this.parseQuotedLocalPart(address));
                if (localPartSB.toString().length() == 2) {
                    throw new AddressException("No quoted local-part (user account) found at position " + (this.pos + 2) + " in '" + address + "'", address, this.pos + 2);
                }
            } else {
                localPartSB.append(this.parseUnquotedLocalPart(address));
                if (localPartSB.toString().length() == 0) {
                    throw new AddressException("No local-part (user account) found at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
                }
            }
            if (this.pos >= address.length() || address.charAt(this.pos) != '@') {
                throw new AddressException("Did not find @ between local-part and domain at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
            }
            ++this.pos;
            while (true) {
                if (address.charAt(this.pos) == '#') {
                    domainSB.append(this.parseNumber(address));
                } else if (address.charAt(this.pos) == '[') {
                    domainSB.append(this.parseDomainLiteral(address));
                } else {
                    domainSB.append(this.parseDomain(address));
                }
                if (this.pos >= address.length() || address.charAt(this.pos) != '.') break;
                domainSB.append('.');
                ++this.pos;
            }
            if (domainSB.toString().length() == 0) {
                throw new AddressException("No domain found at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new AddressException("Out of data at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
        }
        this.localPart = localPartSB.toString();
        this.domain = domainSB.toString();
    }

    public MailAddress(String localPart, String domain) throws AddressException {
        this(new InternetAddress(localPart + "@" + domain));
    }

    public MailAddress(InternetAddress address) throws AddressException {
        this(address.getAddress());
    }

    public String getHost() {
        return this.getDomain();
    }

    public String getDomain() {
        if (!this.domain.startsWith("[") || !this.domain.endsWith("]")) {
            return this.domain;
        }
        return this.domain.substring(1, this.domain.length() - 1);
    }

    public String getUser() {
        return this.getLocalPart();
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String toString() {
        StringBuffer addressBuffer = new StringBuffer(128).append(this.localPart).append("@").append(this.domain);
        return addressBuffer.toString();
    }

    public InternetAddress toInternetAddress() {
        try {
            return new InternetAddress(this.toString());
        }
        catch (AddressException ae) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            String theString = (String)obj;
            return this.toString().equalsIgnoreCase(theString);
        }
        if (obj instanceof MailAddress) {
            MailAddress addr = (MailAddress)obj;
            return this.getLocalPart().equalsIgnoreCase(addr.getLocalPart()) && this.getDomain().equalsIgnoreCase(addr.getDomain());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().toLowerCase(Locale.US).hashCode();
    }

    private String parseQuotedLocalPart(String address) throws AddressException {
        StringBuffer resultSB = new StringBuffer();
        resultSB.append('\"');
        ++this.pos;
        while (true) {
            if (address.charAt(this.pos) == '\"') {
                resultSB.append('\"');
                ++this.pos;
                break;
            }
            if (address.charAt(this.pos) == '\\') {
                resultSB.append('\\');
                ++this.pos;
                char x = address.charAt(this.pos);
                if (x < '\u0000' || x > '\u007f') {
                    throw new AddressException("Invalid \\ syntaxed character at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
                }
                resultSB.append(x);
                ++this.pos;
                continue;
            }
            char q = address.charAt(this.pos);
            if (q <= '\u0000' || q == '\n' || q == '\r' || q == '\"' || q == '\\') {
                throw new AddressException("Unquoted local-part (user account) must be one of the 128 ASCI characters exception <CR>, <LF>, quote (\"), or backslash (\\) at position " + (this.pos + 1) + " in '" + address + "'");
            }
            resultSB.append(q);
            ++this.pos;
        }
        return resultSB.toString();
    }

    private String parseUnquotedLocalPart(String address) throws AddressException {
        StringBuffer resultSB = new StringBuffer();
        boolean lastCharDot = false;
        while (true) {
            if (address.charAt(this.pos) == '\\') {
                resultSB.append('\\');
                ++this.pos;
                char x = address.charAt(this.pos);
                if (x < '\u0000' || x > '\u007f') {
                    throw new AddressException("Invalid \\ syntaxed character at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
                }
                resultSB.append(x);
                ++this.pos;
                lastCharDot = false;
                continue;
            }
            if (address.charAt(this.pos) == '.') {
                resultSB.append('.');
                ++this.pos;
                lastCharDot = true;
                continue;
            }
            if (address.charAt(this.pos) == '@') break;
            char c = address.charAt(this.pos);
            if (c <= '\u001f' || c >= '\u007f' || c == ' ') {
                throw new AddressException("Invalid character in local-part (user account) at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
            }
            for (int i = 0; i < SPECIAL.length; ++i) {
                if (c != SPECIAL[i]) continue;
                throw new AddressException("Invalid character in local-part (user account) at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
            }
            resultSB.append(c);
            ++this.pos;
            lastCharDot = false;
        }
        if (lastCharDot) {
            throw new AddressException("local-part (user account) ended with a \".\", which is invalid in address '" + address + "'", address, this.pos);
        }
        return resultSB.toString();
    }

    private String parseNumber(String address) throws AddressException {
        char d;
        StringBuffer resultSB = new StringBuffer();
        while (this.pos < address.length() && (d = address.charAt(this.pos)) != '.') {
            if (d < '0' || d > '9') {
                throw new AddressException("In domain, did not find a number in # address at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
            }
            resultSB.append(d);
            ++this.pos;
        }
        return resultSB.toString();
    }

    private String parseDomainLiteral(String address) throws AddressException {
        while (address.indexOf("\\") > -1) {
            address = address.substring(0, address.indexOf("\\")) + address.substring(address.indexOf("\\") + 1);
        }
        StringBuffer resultSB = new StringBuffer();
        resultSB.append(address.charAt(this.pos));
        ++this.pos;
        for (int octet = 0; octet < 4; ++octet) {
            char d;
            StringBuffer snumSB = new StringBuffer();
            for (int digits = 0; digits < 3 && (d = address.charAt(this.pos)) != '.' && d != ']'; ++digits) {
                if (d < '0' || d > '9') {
                    throw new AddressException("Invalid number at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
                }
                snumSB.append(d);
                ++this.pos;
            }
            if (snumSB.toString().length() == 0) {
                throw new AddressException("Number not found at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
            }
            try {
                int snum = Integer.parseInt(snumSB.toString());
                if (snum > 255) {
                    throw new AddressException("Invalid number at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
                }
            }
            catch (NumberFormatException nfe) {
                throw new AddressException("Invalid number at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
            }
            resultSB.append(snumSB.toString());
            if (address.charAt(this.pos) == ']') {
                if (octet >= 3) break;
                throw new AddressException("End of number reached too quickly at " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
            }
            if (address.charAt(this.pos) != '.') continue;
            resultSB.append('.');
            ++this.pos;
        }
        if (address.charAt(this.pos) != ']') {
            throw new AddressException("Did not find closing bracket \"]\" in domain at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
        }
        resultSB.append(']');
        ++this.pos;
        return resultSB.toString();
    }

    private String parseDomain(String address) throws AddressException {
        String result;
        StringBuffer resultSB = new StringBuffer();
        while (this.pos < address.length()) {
            char ch = address.charAt(this.pos);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '-') {
                resultSB.append(ch);
                ++this.pos;
                continue;
            }
            if (ch == '.') break;
            throw new AddressException("Invalid character at " + this.pos + " in '" + address + "'", address, this.pos);
        }
        if ((result = resultSB.toString()).startsWith("-") || result.endsWith("-")) {
            throw new AddressException("Domain name cannot begin or end with a hyphen \"-\" at position " + (this.pos + 1) + " in '" + address + "'", address, this.pos + 1);
        }
        return result;
    }
}

