/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import java.util.LinkedList;
import java.util.List;
import org.apache.james.protocols.api.Response;

public abstract class AbstractResponse
implements Response {
    private String retCode = null;
    protected final List<CharSequence> lines = new LinkedList<CharSequence>();
    private boolean endSession = false;

    protected AbstractResponse() {
    }

    public AbstractResponse(String code, CharSequence description) {
        if (code == null) {
            throw new IllegalArgumentException("code can not be null");
        }
        this.setRetCode(code);
        this.appendLine(description);
    }

    public void appendLine(CharSequence line) {
        this.lines.add(line);
    }

    @Override
    public String getRetCode() {
        return this.retCode;
    }

    public void setRetCode(String retCode) {
        this.retCode = retCode.trim();
    }

    @Override
    public boolean isEndSession() {
        return this.endSession;
    }

    public void setEndSession(boolean endSession) {
        this.endSession = endSession;
    }

    public final String toString() {
        return this.getLines().toString();
    }

    public Response immutable() {
        return new Response(){

            @Override
            public boolean isEndSession() {
                return AbstractResponse.this.isEndSession();
            }

            @Override
            public String getRetCode() {
                return AbstractResponse.this.getRetCode();
            }

            @Override
            public List<CharSequence> getLines() {
                return AbstractResponse.this.getLines();
            }

            public String toString() {
                return AbstractResponse.this.toString();
            }
        };
    }
}

