/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.protocols.api.ProtocolConfiguration;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.ProtocolTransport;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;

public class ProtocolSessionImpl
implements ProtocolSession {
    private final ProtocolTransport transport;
    private final Map<ProtocolSession.AttachmentKey<?>, Object> connectionState;
    private final Map<ProtocolSession.AttachmentKey<?>, Object> sessionState;
    private Username username;
    protected final ProtocolConfiguration config;
    private boolean needsCommandInjectionDetection;
    private static final String DELIMITER = "\r\n";

    public ProtocolSessionImpl(ProtocolTransport transport, ProtocolConfiguration config) {
        this.transport = transport;
        this.connectionState = new HashMap();
        this.sessionState = new HashMap();
        this.config = config;
        this.needsCommandInjectionDetection = true;
    }

    @Override
    public boolean needsCommandInjectionDetection() {
        return this.needsCommandInjectionDetection;
    }

    @Override
    public void startDetectingCommandInjection() {
        this.needsCommandInjectionDetection = true;
    }

    @Override
    public void stopDetectingCommandInjection() {
        this.needsCommandInjectionDetection = false;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.transport.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.transport.getRemoteAddress();
    }

    @Override
    public Username getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(Username username) {
        this.username = username;
    }

    public ProtocolTransport getProtocolTransport() {
        return this.transport;
    }

    @Override
    public boolean isStartTLSSupported() {
        return this.transport.isStartTLSSupported();
    }

    @Override
    public boolean isStartTLSEnforced() {
        return this.transport.isStartTLSEnforced();
    }

    @Override
    public boolean isTLSStarted() {
        return this.transport.isTLSStarted();
    }

    @Override
    public String getSessionID() {
        return this.transport.getId();
    }

    @Override
    public Map<ProtocolSession.AttachmentKey<?>, Object> getConnectionState() {
        return this.connectionState;
    }

    @Override
    public Map<ProtocolSession.AttachmentKey<?>, Object> getState() {
        return this.sessionState;
    }

    @Override
    public Response newLineTooLongResponse() {
        return null;
    }

    @Override
    public Response newFatalErrorResponse() {
        return null;
    }

    @Override
    public Response newCommandNotFoundErrorResponse() {
        return null;
    }

    @Override
    public void resetState() {
        this.sessionState.clear();
    }

    @Override
    public ProtocolConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public <T> Optional<T> setAttachment(ProtocolSession.AttachmentKey<T> key, T value, ProtocolSession.State state) {
        Preconditions.checkNotNull(key, (Object)"key cannot be null");
        Preconditions.checkNotNull(value, (Object)"value cannot be null");
        if (state == ProtocolSession.State.Connection) {
            return key.convert(this.connectionState.put(key, value));
        }
        return key.convert(this.sessionState.put(key, value));
    }

    @Override
    public <T> Optional<T> removeAttachment(ProtocolSession.AttachmentKey<T> key, ProtocolSession.State state) {
        Preconditions.checkNotNull(key, (Object)"key cannot be null");
        if (state == ProtocolSession.State.Connection) {
            return key.convert(this.connectionState.remove(key));
        }
        return key.convert(this.sessionState.remove(key));
    }

    @Override
    public <T> Optional<T> getAttachment(ProtocolSession.AttachmentKey<T> key, ProtocolSession.State state) {
        if (state == ProtocolSession.State.Connection) {
            return key.convert(this.connectionState.get(key));
        }
        return key.convert(this.sessionState.get(key));
    }

    @Override
    public Charset getCharset() {
        return StandardCharsets.US_ASCII;
    }

    @Override
    public String getLineDelimiter() {
        return DELIMITER;
    }

    @Override
    public void popLineHandler() {
        this.transport.popLineHandler();
    }

    @Override
    public int getPushedLineHandlerCount() {
        return this.transport.getPushedLineHandlerCount();
    }

    @Override
    public <T extends ProtocolSession> void pushLineHandler(LineHandler<T> overrideCommandHandler) {
        this.transport.pushLineHandler(overrideCommandHandler, this);
    }
}

