/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.lmtpserver.hook;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.protocols.lmtp.hook.DeliverToRecipientHook;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class MailboxDeliverToRecipientHandler
implements DeliverToRecipientHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailboxDeliverToRecipientHandler.class);
    private final UsersRepository users;
    private final MailboxManager mailboxManager;

    @Inject
    public MailboxDeliverToRecipientHandler(UsersRepository users, @Named(value="mailboxmanager") MailboxManager mailboxManager) {
        this.users = users;
        this.mailboxManager = mailboxManager;
    }

    public HookResult deliver(SMTPSession session, MailAddress recipient, final MailEnvelope envelope) {
        try {
            Username username = this.users.getUsername(recipient);
            MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
            MailboxPath inbox = MailboxPath.inbox((MailboxSession)mailboxSession);
            this.mailboxManager.startProcessingRequest(mailboxSession);
            if (!((Boolean)Mono.from((Publisher)this.mailboxManager.mailboxExists(inbox, mailboxSession)).block()).booleanValue()) {
                Optional mailboxId = this.mailboxManager.createMailbox(inbox, mailboxSession);
                LOGGER.info("Provisioning INBOX. {} created.", (Object)mailboxId);
            }
            this.mailboxManager.getMailbox(MailboxPath.inbox((Username)username), mailboxSession).appendMessage(MessageManager.AppendCommand.builder().recent().build(new Content(){

                public InputStream getInputStream() throws IOException {
                    return envelope.getMessageInputStream();
                }

                public long size() {
                    return envelope.getSize();
                }
            }), mailboxSession);
            this.mailboxManager.endProcessingRequest(mailboxSession);
            return HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpReturnCode("250").smtpDescription(DSNStatus.getStatus((int)2, (String)"6.0") + " Message received <" + recipient.asString() + ">").build();
        }
        catch (MailboxException | UsersRepositoryException e) {
            LOGGER.error("Unexpected error handling DATA stream", e);
            return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpDescription(" Temporary error deliver message to " + String.valueOf(recipient)).build();
        }
    }
}

