/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tools.copier;

import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.copier.MailboxCopier;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.store.streaming.InputStreamContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxCopierImpl
implements MailboxCopier {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MailboxCopierImpl.class.getName());

    public void copyMailboxes(MailboxManager srcMailboxManager, MailboxManager dstMailboxManager) throws MailboxException, IOException {
        Calendar start = Calendar.getInstance();
        List mailboxPathList = null;
        MailboxSession srcMailboxSession = srcMailboxManager.createSystemSession(Username.of((String)"manager"));
        srcMailboxManager.startProcessingRequest(srcMailboxSession);
        mailboxPathList = srcMailboxManager.list(srcMailboxSession);
        srcMailboxManager.endProcessingRequest(srcMailboxSession);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Found " + mailboxPathList.size() + " mailboxes in source mailbox manager.");
            for (int i = 0; i < mailboxPathList.size(); ++i) {
                LOGGER.info("Mailbox#" + i + " path=" + String.valueOf(mailboxPathList.get(i)));
            }
        }
        MailboxPath mailboxPath = null;
        for (int i = 0; i < mailboxPathList.size(); ++i) {
            mailboxPath = (MailboxPath)mailboxPathList.get(i);
            if (mailboxPath.getName() != null && mailboxPath.getName().trim().length() > 0) {
                LOGGER.info("Ready to copy source mailbox path={}", (Object)mailboxPath);
                srcMailboxSession = srcMailboxManager.createSystemSession(mailboxPath.getUser());
                MailboxSession dstMailboxSession = dstMailboxManager.createSystemSession(mailboxPath.getUser());
                dstMailboxManager.startProcessingRequest(dstMailboxSession);
                try {
                    dstMailboxManager.createMailbox(mailboxPath, dstMailboxSession);
                    LOGGER.info("Destination mailbox {}/{} created with path={} after {} ms.", new Object[]{i, mailboxPathList.size(), mailboxPath, Calendar.getInstance().getTimeInMillis() - start.getTimeInMillis()});
                }
                catch (MailboxExistsException e) {
                    LOGGER.error("Mailbox {} with path={} already exists.", new Object[]{i, mailboxPath, e});
                }
                dstMailboxManager.endProcessingRequest(dstMailboxSession);
                srcMailboxManager.startProcessingRequest(srcMailboxSession);
                MessageManager srcMessageManager = srcMailboxManager.getMailbox(mailboxPath, srcMailboxSession);
                srcMailboxManager.endProcessingRequest(srcMailboxSession);
                dstMailboxManager.startProcessingRequest(dstMailboxSession);
                MessageManager dstMessageManager = dstMailboxManager.getMailbox(mailboxPath, dstMailboxSession);
                int j = 0;
                MessageResultIterator messageResultIterator = srcMessageManager.getMessages(MessageRange.all(), FetchGroup.FULL_CONTENT, srcMailboxSession);
                while (messageResultIterator.hasNext()) {
                    MessageResult messageResult = (MessageResult)messageResultIterator.next();
                    InputStreamContent content = (InputStreamContent)messageResult.getFullContent();
                    dstMailboxManager.startProcessingRequest(dstMailboxSession);
                    dstMessageManager.appendMessage(MessageManager.AppendCommand.builder().withInternalDate(messageResult.getInternalDate()).isRecent(messageResult.getFlags().contains(Flags.Flag.RECENT)).withFlags(messageResult.getFlags()).build((Content)content), dstMailboxSession);
                    dstMailboxManager.endProcessingRequest(dstMailboxSession);
                    LOGGER.info("MailboxMessage #{} appended in destination mailbox with path={}", (Object)j, (Object)mailboxPath);
                    ++j;
                }
                dstMailboxManager.endProcessingRequest(dstMailboxSession);
                continue;
            }
            LOGGER.info("Destination mailbox {}/{} with path={} has a null or empty name", new Object[]{i, mailboxPathList.size(), mailboxPath});
        }
        LOGGER.info("Mailboxes copied in {} ms.", (Object)(Calendar.getInstance().getTimeInMillis() - start.getTimeInMillis()));
    }
}

