/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class JVMMailboxPathLocker
implements MailboxPathLocker {
    private final ConcurrentHashMap<MailboxPath, ReadWriteLock> paths = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeWithLock(MailboxPath path, MailboxPathLocker.LockAwareExecution<T> execution, MailboxPathLocker.LockType writeLock) throws MailboxException {
        try {
            this.lock(path, writeLock);
            Object object = execution.execute();
            return (T)object;
        }
        finally {
            this.unlock(path, writeLock);
        }
    }

    public <T> Publisher<T> executeReactiveWithLockReactive(MailboxPath path, Publisher<T> execution, MailboxPathLocker.LockType lockType) {
        return Mono.fromCallable(() -> this.executeWithLock(path, () -> Mono.from((Publisher)execution).block(), lockType)).subscribeOn(Schedulers.elastic());
    }

    private MailboxPath lock(MailboxPath path, MailboxPathLocker.LockType lockType) {
        ReadWriteLock storedLock;
        ReadWriteLock lock = this.paths.get(path);
        if (lock == null && (storedLock = this.paths.putIfAbsent(path, lock = new ReentrantReadWriteLock())) != null) {
            lock = storedLock;
        }
        this.getLock(lock, lockType).lock();
        return path;
    }

    private MailboxPath unlock(MailboxPath path, MailboxPathLocker.LockType lockType) {
        ReadWriteLock lock = this.paths.get(path);
        if (lock != null) {
            this.getLock(lock, lockType).unlock();
        }
        return path;
    }

    private Lock getLock(ReadWriteLock lock, MailboxPathLocker.LockType lockType) {
        switch (lockType) {
            case Write: {
                return lock.writeLock();
            }
            case Read: {
                return lock.readLock();
            }
        }
        throw new NotImplementedException("Unsupported lock tuype " + String.valueOf(lockType));
    }
}

