/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.migration;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentDAOV2;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentMessageIdDAO;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class AttachmentMessageIdMigration
implements Migration {
    public static final Logger LOGGER = LoggerFactory.getLogger(AttachmentMessageIdMigration.class);
    public static final TaskType TYPE = TaskType.of((String)"cassandra-attachment-messageid-migration");
    private final CassandraAttachmentMessageIdDAO attachmentMessageIdDAO;
    private final CassandraAttachmentDAOV2 attachmentDAO;

    @Inject
    public AttachmentMessageIdMigration(CassandraAttachmentMessageIdDAO attachmentMessageIdDAO, CassandraAttachmentDAOV2 attachmentDAO) {
        this.attachmentMessageIdDAO = attachmentMessageIdDAO;
        this.attachmentDAO = attachmentDAO;
    }

    public void apply() {
        this.attachmentMessageIdDAO.listAll().flatMap(this::migrate, 16).blockLast();
    }

    private Mono<Void> migrate(Pair<AttachmentId, MessageId> entry) {
        return this.attachmentDAO.insertMessageId((AttachmentId)entry.getKey(), (MessageId)entry.getValue());
    }

    public Task asTask() {
        return new AttachmentMessageIdMigrationTask(this);
    }

    AdditionalInformation getAdditionalInformation() {
        return new AdditionalInformation(Clock.systemUTC().instant());
    }

    static class AttachmentMessageIdMigrationTask
    implements Task {
        private final AttachmentMessageIdMigration migration;

        AttachmentMessageIdMigrationTask(AttachmentMessageIdMigration migration) {
            this.migration = migration;
        }

        public Task.Result run() throws InterruptedException {
            return this.migration.runTask();
        }

        public TaskType type() {
            return TYPE;
        }

        public Optional<TaskExecutionDetails.AdditionalInformation> details() {
            return Optional.of(this.migration.getAdditionalInformation());
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;

        public AdditionalInformation(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

