/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriPathTemplate {
    private static final Pattern FULL_SPLAT_PATTERN = Pattern.compile("[\\*][\\*]");
    private static final String FULL_SPLAT_REPLACEMENT = ".*";
    private static final Pattern NAME_SPLAT_PATTERN = Pattern.compile("\\{([^/]+?)\\}[\\*][\\*]");
    private static final Pattern NAME_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private final List<String> pathVariables = new ArrayList<String>();
    private final HashMap<String, Matcher> matchers = new HashMap();
    private final HashMap<String, Map<String, String>> vars = new HashMap();
    private final Pattern uriPattern;

    private static String getNameSplatReplacement(String name) {
        return "(?<" + name + ">.*)";
    }

    private static String getNameReplacement(String name) {
        return "(?<" + name + ">[^\\/]*)";
    }

    static String filterQueryParams(String uri) {
        int hasQuery = uri.lastIndexOf(63);
        if (hasQuery != -1) {
            return uri.substring(0, hasQuery);
        }
        return uri;
    }

    UriPathTemplate(String uriPattern) {
        String name;
        int i;
        Object s = "^" + UriPathTemplate.filterQueryParams(uriPattern);
        Matcher m = NAME_SPLAT_PATTERN.matcher((CharSequence)s);
        while (m.find()) {
            for (i = 1; i <= m.groupCount(); ++i) {
                name = m.group(i);
                this.pathVariables.add(name);
                s = m.replaceFirst(UriPathTemplate.getNameSplatReplacement(name));
                m.reset((CharSequence)s);
            }
        }
        m = NAME_PATTERN.matcher((CharSequence)s);
        while (m.find()) {
            for (i = 1; i <= m.groupCount(); ++i) {
                name = m.group(i);
                this.pathVariables.add(name);
                s = m.replaceFirst(UriPathTemplate.getNameReplacement(name));
                m.reset((CharSequence)s);
            }
        }
        m = FULL_SPLAT_PATTERN.matcher((CharSequence)s);
        while (m.find()) {
            s = m.replaceAll(FULL_SPLAT_REPLACEMENT);
            m.reset((CharSequence)s);
        }
        this.uriPattern = Pattern.compile((String)s + "$");
    }

    public boolean matches(String uri) {
        return this.matcher(uri).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Matcher matcher(String uri) {
        Matcher m = this.matchers.get(uri = UriPathTemplate.filterQueryParams(uri));
        if (null == m) {
            m = this.uriPattern.matcher(uri);
            HashMap<String, Matcher> hashMap = this.matchers;
            synchronized (hashMap) {
                this.matchers.put(uri, m);
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map<String, String> match(String uri) {
        Map<String, String> pathParameters = this.vars.get(uri);
        if (null != pathParameters) {
            return pathParameters;
        }
        pathParameters = new HashMap<String, String>();
        Matcher m = this.matcher(uri);
        if (m.matches()) {
            int i = 1;
            for (String name : this.pathVariables) {
                String val = m.group(i++);
                pathParameters.put(name, val);
            }
        }
        HashMap<String, Map<String, String>> hashMap = this.vars;
        synchronized (hashMap) {
            this.vars.put(uri, pathParameters);
        }
        return pathParameters;
    }
}

