/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.redirect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.util.SizeUtils;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyMailetsMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifyMailetsMessage.class);
    private static final char LINE_BREAK = '\n';

    public String generateMessage(String parameterMessage, Mail originalMail) throws MessagingException {
        MimeMessage message = originalMail.getMessage();
        StringBuilder builder = new StringBuilder();
        builder.append(parameterMessage).append('\n');
        if (originalMail.getErrorMessage() != null) {
            builder.append('\n').append("Error message below:").append('\n').append(originalMail.getErrorMessage()).append('\n');
        }
        builder.append('\n').append("Message details:").append('\n');
        if (message.getSubject() != null) {
            builder.append("  Subject: ").append(NotifyMailetsMessage.safelyDecode(message.getSubject())).append('\n');
        }
        if (message.getSentDate() != null) {
            builder.append("  Sent date: " + String.valueOf(message.getSentDate())).append('\n');
        }
        builder.append("  MAIL FROM: " + originalMail.getMaybeSender().asString()).append('\n');
        boolean firstRecipient = true;
        for (MailAddress recipient : originalMail.getRecipients()) {
            if (firstRecipient) {
                builder.append("  RCPT TO: " + String.valueOf(recipient)).append('\n');
                firstRecipient = false;
                continue;
            }
            builder.append("           " + String.valueOf(recipient)).append('\n');
        }
        this.appendAddresses(builder, "From", message.getHeader("From"));
        this.appendAddresses(builder, "To", message.getHeader("To"));
        this.appendAddresses(builder, "CC", message.getHeader("Cc"));
        NotifyMailetsMessage.getMessageSizeEstimation(originalMail).ifPresent(size -> builder.append("  Size: ").append(SizeUtils.humanReadableSize(size)).append('\n'));
        if (message.getLineCount() >= 0) {
            builder.append("  Number of lines: " + message.getLineCount()).append('\n');
        }
        return builder.toString();
    }

    @VisibleForTesting
    static Optional<Long> getMessageSizeEstimation(Mail mail) {
        try {
            return Optional.of(mail.getMessageSize()).filter(size -> size > 0L);
        }
        catch (MessagingException e) {
            LOGGER.debug("Could not estimate mail size", (Throwable)e);
            return Optional.empty();
        }
    }

    @VisibleForTesting
    static String safelyDecode(String text) {
        try {
            return MimeUtility.decodeText((String)text);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Could not decode following value {}", (Object)text, (Object)e);
            return text;
        }
    }

    private void appendAddresses(StringBuilder builder, String title, String[] addresses) {
        if (addresses != null) {
            builder.append("  " + title + ": ").append('\n');
            for (String address : this.flatten(addresses)) {
                builder.append(NotifyMailetsMessage.safelyDecode(address)).append(" ").append('\n');
            }
            builder.append('\n');
        }
    }

    private List<String> flatten(String[] addresses) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String address : addresses) {
            builder.addAll(Splitter.on((char)',').trimResults().split((CharSequence)address));
        }
        return builder.build();
    }
}

