/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import com.google.common.base.Preconditions;
import com.sun.mail.smtp.SMTPAddressFailedException;
import com.sun.mail.smtp.SMTPSendFailedException;
import com.sun.mail.smtp.SMTPSenderFailedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedMessagingException {
    private static final Logger logger = LoggerFactory.getLogger(EnhancedMessagingException.class);
    private final MessagingException messagingException;
    private final Optional<Integer> returnCode;
    private final Optional<Integer> nestedReturnCode;

    public EnhancedMessagingException(MessagingException messagingException) {
        this.messagingException = messagingException;
        this.returnCode = this.computeReturnCode();
        this.nestedReturnCode = this.computeNestedReturnCode();
    }

    public boolean hasReturnCode() {
        return this.returnCode.isPresent();
    }

    public boolean hasNestedReturnCode() {
        return this.nestedReturnCode.isPresent();
    }

    public boolean isServerError() {
        return this.isServerError(this.returnCode) || this.isServerError(this.nestedReturnCode);
    }

    private boolean isServerError(Optional<Integer> returnCode) {
        return returnCode.isPresent() && returnCode.get() >= 500 && returnCode.get() <= 599 || this.messageIndicatesServerException();
    }

    private boolean messageIndicatesServerException() {
        return Optional.ofNullable(this.messagingException.getMessage()).map(this.startWith5()).orElse(false);
    }

    private Function<String, Boolean> startWith5() {
        return message -> message.startsWith("5");
    }

    private Optional<Integer> computeReturnCode() {
        if (this.messagingException instanceof SMTPAddressFailedException) {
            SMTPAddressFailedException addressFailedException = (SMTPAddressFailedException)this.messagingException;
            return Optional.of(addressFailedException.getReturnCode());
        }
        if (this.messagingException instanceof SMTPSendFailedException) {
            SMTPSendFailedException sendFailedException = (SMTPSendFailedException)this.messagingException;
            return Optional.of(sendFailedException.getReturnCode());
        }
        if (this.messagingException instanceof SMTPSenderFailedException) {
            SMTPSenderFailedException senderFailedException = (SMTPSenderFailedException)this.messagingException;
            return Optional.of(senderFailedException.getReturnCode());
        }
        if (((Object)((Object)this.messagingException)).getClass().getName().endsWith(".SMTPSendFailedException") || ((Object)((Object)this.messagingException)).getClass().getName().endsWith(".SMTPAddressSucceededException")) {
            try {
                return Optional.of((Integer)this.invokeGetter((Object)this.messagingException, "getReturnCode"));
            }
            catch (ClassCastException | IllegalArgumentException | IllegalStateException e) {
                logger.error("unexpected exception", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public Optional<String> computeCommand() {
        if (this.hasReturnCode()) {
            try {
                return Optional.of((String)this.invokeGetter((Object)this.messagingException, "getCommand"));
            }
            catch (ClassCastException | IllegalArgumentException | IllegalStateException e) {
                logger.error("unexpected exception", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public Optional<InternetAddress> computeAddress() {
        if (this.hasReturnCode()) {
            try {
                return Optional.of((InternetAddress)this.invokeGetter((Object)this.messagingException, "getAddress"));
            }
            catch (ClassCastException | IllegalArgumentException | IllegalStateException e) {
                logger.error("unexpected exception", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public String computeAction() {
        return ((Object)((Object)this.messagingException)).getClass().getName().endsWith(".SMTPAddressFailedException") ? "FAILED" : "SUCCEEDED";
    }

    public Optional<Integer> getReturnCode() {
        return this.returnCode;
    }

    private Optional<Integer> computeNestedReturnCode() {
        EnhancedMessagingException currentMessagingException = this;
        while (true) {
            Optional<Integer> returnCode;
            if ((returnCode = currentMessagingException.computeReturnCode()).isPresent()) {
                return returnCode;
            }
            if (!currentMessagingException.hasNestedMessagingException()) break;
            currentMessagingException = currentMessagingException.getNestedMessagingException();
        }
        return Optional.empty();
    }

    private boolean hasNestedMessagingException() {
        return this.messagingException.getNextException() != null && this.messagingException.getNextException() instanceof MessagingException;
    }

    private EnhancedMessagingException getNestedMessagingException() {
        Preconditions.checkState((boolean)this.hasNestedMessagingException());
        return new EnhancedMessagingException((MessagingException)((Object)this.messagingException.getNextException()));
    }

    private Object invokeGetter(Object target, String getter) {
        try {
            Method getAddress = target.getClass().getMethod(getter, new Class[0]);
            return getAddress.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            return new IllegalStateException("Exception invoking " + getter + " on a " + String.valueOf(target.getClass()) + " object");
        }
    }
}

