/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableListMultimap;
import com.sun.mail.smtp.SMTPMessage;
import com.sun.mail.smtp.SMTPTransport;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.remote.delivery.ExecutionResult;
import org.apache.james.transport.mailets.remote.delivery.RemoteDeliveryConfiguration;
import org.apache.mailet.DsnParameters;
import org.apache.mailet.HostAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.Converter7Bit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailDelivrerToHost {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailDelivrerToHost.class);
    public static final String BIT_MIME_8 = "8BITMIME";
    private final RemoteDeliveryConfiguration configuration;
    private final Converter7Bit converter7Bit;
    private final Session smtpSession;
    private final Session smtpsSession;

    public MailDelivrerToHost(RemoteDeliveryConfiguration remoteDeliveryConfiguration, MailetContext mailetContext) {
        this.configuration = remoteDeliveryConfiguration;
        this.converter7Bit = new Converter7Bit(mailetContext);
        if (this.configuration.isSSLEnable()) {
            this.smtpSession = Session.getInstance((Properties)this.configuration.createFinalJavaxProperties());
            this.smtpsSession = Session.getInstance((Properties)this.configuration.createFinalJavaxPropertiesWithSSL());
        } else {
            this.smtpsSession = this.smtpSession = Session.getInstance((Properties)this.configuration.createFinalJavaxProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult tryDeliveryToHost(Mail mail, Collection<InternetAddress> addr, HostAddress outgoingMailServer) throws MessagingException {
        Session session = this.selectSession(outgoingMailServer);
        Properties props = this.getPropertiesForMail(mail, session);
        LOGGER.debug("Attempting delivery of {} to host {} at {} from {}", new Object[]{mail.getName(), outgoingMailServer.getHostName(), outgoingMailServer.getHost(), props.get(this.inContext(session, "mail.smtp.from"))});
        SMTPTransport transport = null;
        try {
            transport = (SMTPTransport)session.getTransport((URLName)outgoingMailServer);
            transport.setLocalHost(props.getProperty(this.inContext(session, "mail.smtp.localhost"), this.configuration.getHeloNameProvider().getHeloName()));
            this.connect(outgoingMailServer, transport);
            if (mail.dsnParameters().isPresent()) {
                this.sendDSNAwareEmail(mail, transport, addr);
            } else {
                transport.sendMessage((Message)this.adaptToTransport(mail.getMessage(), transport), (Address[])addr.toArray(InternetAddress[]::new));
            }
            LOGGER.debug("Mail ({})  sent successfully to {} at {} from {} for {}", new Object[]{mail.getName(), outgoingMailServer.getHostName(), outgoingMailServer.getHost(), props.get(this.inContext(session, "mail.smtp.from")), mail.getRecipients()});
        }
        finally {
            this.closeTransport(mail, outgoingMailServer, transport);
        }
        return ExecutionResult.success();
    }

    private Session selectSession(HostAddress host) {
        if (host.getProtocol().equalsIgnoreCase("smtps")) {
            return this.smtpsSession;
        }
        return this.smtpSession;
    }

    private String inContext(Session session, String name) {
        if (session.getProperties().containsKey("mail.smtps.ssl.enable")) {
            return name.replace("smtp", "smtps");
        }
        return name;
    }

    private void sendDSNAwareEmail(Mail mail, SMTPTransport transport, Collection<InternetAddress> addresses) {
        ((ImmutableListMultimap)addresses.stream().map(address -> Pair.of(mail.dsnParameters().flatMap(Throwing.function(dsn -> Optional.ofNullable((DsnParameters.RecipientDsnParameters)dsn.getRcptParameters().get((Object)new MailAddress(address.toString())))).sneakyThrow()).flatMap(DsnParameters.RecipientDsnParameters::getNotifyParameter).map(this::toJavaxNotify), (Object)address)).collect(ImmutableListMultimap.toImmutableListMultimap(Pair::getKey, Pair::getValue))).asMap().forEach(Throwing.biConsumer((maybeNotify, recipients) -> {
            SMTPMessage smtpMessage = this.asSmtpMessage(mail, transport);
            maybeNotify.ifPresent(arg_0 -> ((SMTPMessage)smtpMessage).setNotifyOptions(arg_0));
            transport.sendMessage((Message)smtpMessage, (Address[])recipients.toArray(InternetAddress[]::new));
        }).sneakyThrow());
    }

    private SMTPMessage asSmtpMessage(Mail mail, SMTPTransport transport) throws MessagingException {
        SMTPMessage smtpMessage = new SMTPMessage(this.adaptToTransport(mail.getMessage(), transport));
        mail.dsnParameters().flatMap(DsnParameters::getRetParameter).map(this::toJavaxRet).ifPresent(arg_0 -> ((SMTPMessage)smtpMessage).setReturnOption(arg_0));
        mail.dsnParameters().flatMap(DsnParameters::getEnvIdParameter).ifPresent(envId -> {
            if (transport.supportsExtension("DSN")) {
                smtpMessage.setMailExtension("ENVID=" + envId.asString());
            }
        });
        return smtpMessage;
    }

    private int toJavaxRet(DsnParameters.Ret ret) {
        switch (ret) {
            case FULL: {
                return 1;
            }
            case HDRS: {
                return 2;
            }
        }
        throw new NotImplementedException(String.valueOf(ret) + " cannot be converted to javax.mail parameters");
    }

    private int toJavaxNotify(EnumSet<DsnParameters.Notify> notifies) {
        return notifies.stream().mapToInt(this::toJavaxNotify).sum();
    }

    private int toJavaxNotify(DsnParameters.Notify notify) {
        switch (notify) {
            case NEVER: {
                return -1;
            }
            case SUCCESS: {
                return 1;
            }
            case FAILURE: {
                return 2;
            }
            case DELAY: {
                return 4;
            }
        }
        throw new NotImplementedException(String.valueOf(notify) + " cannot be converted to javax.mail parameters");
    }

    private Properties getPropertiesForMail(Mail mail, Session session) {
        Properties props = session.getProperties();
        props.put(this.inContext(session, "mail.smtp.from"), mail.getMaybeSender().asString());
        return props;
    }

    private void connect(HostAddress outgoingMailServer, SMTPTransport transport) throws MessagingException {
        if (this.configuration.getAuthUser() != null) {
            transport.connect(outgoingMailServer.getHostName(), this.configuration.getAuthUser(), this.configuration.getAuthPass());
        } else {
            transport.connect();
        }
    }

    private MimeMessage adaptToTransport(MimeMessage message, SMTPTransport transport) throws MessagingException {
        if (this.shouldAdapt(transport)) {
            try {
                this.converter7Bit.convertTo7Bit(message);
            }
            catch (IOException e) {
                LOGGER.error("Error during the conversion to 7 bit.", (Throwable)e);
            }
        }
        return message;
    }

    private boolean shouldAdapt(SMTPTransport transport) {
        return !transport.getClass().getName().endsWith(".SMTPTransport") || !transport.supportsExtension(BIT_MIME_8);
    }

    private void closeTransport(Mail mail, HostAddress outgoingMailServer, SMTPTransport transport) {
        if (transport != null) {
            try {
                transport.close();
            }
            catch (MessagingException e) {
                LOGGER.error("Warning: could not close the SMTP transport after sending mail ({}) to {} at {} for {}; probably the server has already closed the connection. Message is considered to be delivered. Exception: {}", new Object[]{mail.getName(), outgoingMailServer.getHostName(), outgoingMailServer.getHost(), mail.getRecipients(), e.getMessage()});
            }
            transport = null;
        }
    }
}

