/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.internet.InternetAddress;
import org.apache.james.transport.mailets.remote.delivery.ExecutionResult;
import org.apache.james.transport.mailets.remote.delivery.RemoteDeliveryConfiguration;
import org.apache.mailet.Mail;

public class MessageComposer {
    private final RemoteDeliveryConfiguration configuration;

    public MessageComposer(RemoteDeliveryConfiguration configuration) {
        this.configuration = configuration;
    }

    private String fromException(Exception e) {
        if (e.getClass().getName().endsWith(".SMTPSendFailedException")) {
            return "RemoteHost said: " + e.getMessage();
        }
        if (e instanceof SendFailedException) {
            SendFailedException exception = (SendFailedException)e;
            if (exception.getInvalidAddresses().length == 0 && exception.getValidUnsentAddresses().length == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            boolean smtpExFound = false;
            sb.append("RemoteHost said:");
            if (e instanceof MessagingException) {
                Exception ex;
                while ((ex = ((MessagingException)((Object)e)).getNextException()) != null && ex instanceof MessagingException) {
                    e = ex;
                    if (!ex.getClass().getName().endsWith(".SMTPAddressFailedException")) continue;
                    try {
                        InternetAddress ia = (InternetAddress)this.invokeGetter(ex, "getAddress");
                        sb.append(" ( ").append(ia).append(" - [").append(ex.getMessage().replace("\\n", "")).append("] )");
                        smtpExFound = true;
                    }
                    catch (IllegalStateException ia) {
                    }
                    catch (ClassCastException ia) {}
                }
            }
            if (!smtpExFound) {
                boolean invalidAddr = false;
                sb.append(" ( ");
                if (exception.getInvalidAddresses().length > 0) {
                    sb.append(Arrays.toString(exception.getInvalidAddresses()));
                    invalidAddr = true;
                }
                if (exception.getValidUnsentAddresses().length > 0) {
                    if (invalidAddr) {
                        sb.append(" ");
                    }
                    sb.append(Arrays.toString(exception.getValidUnsentAddresses()));
                }
                sb.append(" - [");
                sb.append(exception.getMessage().replace("\\n", ""));
                sb.append("] )");
            }
            return sb.toString();
        }
        return null;
    }

    public String composeFailLogMessage(Mail mail, ExecutionResult executionResult) {
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        out.print(this.permanentAsString(executionResult.isPermanent()) + " exception delivering mail (" + mail.getName() + ")" + this.retrieveExceptionLog(executionResult.getException().orElse(null)) + ": ");
        if (this.configuration.isDebug()) {
            executionResult.getException().ifPresent(e -> e.printStackTrace(out));
        }
        return sout.toString();
    }

    private String permanentAsString(boolean permanent) {
        if (permanent) {
            return "Permanent";
        }
        return "Temporary";
    }

    private String retrieveExceptionLog(Exception ex) {
        String exceptionLog = this.fromException(ex);
        if (exceptionLog != null) {
            return ". " + exceptionLog;
        }
        return "";
    }

    private Object invokeGetter(Object target, String getter) {
        try {
            Method getAddress = target.getClass().getMethod(getter, new Class[0]);
            return getAddress.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            return new IllegalStateException("Exception invoking " + getter + " on a " + String.valueOf(target.getClass()) + " object");
        }
    }
}

