window.config = {
  "name": "Configuration",
  "favicon": "https://www.savignano.net/wp-content/uploads/fbrfg/favicon.ico?v=3",
  "baseUrl": "api/v1",
  "notificationStyle": "banner",
  "auth": {
    "type": "sessioncookie",
    "loginEndpoint": "/auth/login",
    "logoutEndpoint": "/auth/logout",
    "userEndpoint": "/auth/user",
    "changePasswordEndpoint": "/auth/change-password",
    "icons": {
      "changePassword": "retweet",
      "logout": "sign-out"
    }
  },
  "requestHeaders": {
    "Accept": "application/json",
  },
  "errorMessageDataPath": [
    "errors.0",
    "error"
  ],
  "customStyles": {
    "vars": {
      "logoHeaderBackground": '#fff',
    }
  },
  "pages": [
    {
      "name": "Uptrust General",
      "id": "general",
      "icon": "cog",
      "singleItemPage": true,
      "helpUrl": "https://confluence.sss-intra.net/display/SENVOY/Uptrust+Konfiguration",
      "methods": {
        "getAll": {
          "url": "/uptrust/general",
          "dataPath": "data",
          "display": {
            "type": "cards"
          },
          "fields": [
            // General
            {
              "name": "uptrustServerStatus",
              "type": "text"
            },
            {
              "name": "enabled",
              "type": "boolean",
            },
            // Incoming Mail 
            {
              "name": "checkTrust",
              "dataPath": "incomingMail",
              "type": "boolean",
            },
            {
              "name": "serverSideProtectionHandling",
              "dataPath": "incomingMail",
              "type": "boolean",
            },
            // Outgoing Mail
            {
              "name": "protection",
              "dataPath": "outgoingMail",
              "type": "text",
            },
            {
              "name": "protectionFailureBehaviour",
              "dataPath": "outgoingMail",
              "type": "text"
            },
            // Decoration
            {
              "name": "insertProtectionIndicators",
              "dataPath": "decoration",
              "type": "text",
            },
            {
              "name": "protectionIndicatorLocation",
              "dataPath": "decoration",
              "type": "text"
            },
            // Cryptography Encryption
            {
              "name": "pgpSymmetricKeyAlgorithm",
              "dataPath": "cryptography.encryption",
              "type": "text"
            },
            /*
            {
              "name": "smimeSymmetricKeyAlgorithm",
              "dataPath": "cryptography.encryption",
              "type": "text"
            },
            {
              "name": "smimeSymmetricKeySize",
              "dataPath": "cryptography.encryption",
              "type": "text"
            },
            */
            // Cryptography Decryption
            {
              "name": "pgpCheckInline",
              "dataPath": "cryptography.decryption",
              "type": "boolean"
            },
            {
              "name": "pgpBinaryRegex",
              "dataPath": "cryptography.decryption",
              "type": "text"
            },
            // Cryptography Validation
            {
              "name": "pgpCheckInline",
              "dataPath": "cryptography.validation",
              "type": "boolean"
            },
          ],
        },
        "put": {
          "url": "/uptrust/general",
          "fields": [
            // General
            {
              "name": "enabled",
              "type": "boolean",
            },
            // Incoming Mail
            {
              "name": "checkTrust",
              "dataPath": "incomingMail",
              "type": "boolean",
            },
            {
              "name": "serverSideProtectionHandling",
              "dataPath": "incomingMail",
              "type": "boolean",
            },
            // Outgoing Mail
            {
              "name": "protection",
              "dataPath": "outgoingMail",
              "type": "select",
              "options": ["SMIME_ONLY", "SMIME_PREFERRED", "PGP_ONLY", "PGP_PREFERRED"]
            },
            {
              "name": "protectionFailureBehaviour",
              "dataPath": "outgoingMail",
              "type": "select",
              "options": ["CONTINUE", "ABORT"]
            },
            // Decoration
            {
              "name": "insertProtectionIndicators",
              "dataPath": "decoration",
              "type": "select",
              "options": ["ALWAYS", "EXISTING", "NEVER"]
            },
            {
              "name": "protectionIndicatorLocation",
              "dataPath": "decoration",
              "type": "select",
              "options": ["BODY", "SUBJECT"]
            },
            // Cryptography Encryption
            {
              "name": "pgpSymmetricKeyAlgorithm",
              "dataPath": "cryptography.encryption",
              "type": "text",
              "options": [""]
            },
            {
              "name": "smimeSymmetricKeyAlgorithm",
              "dataPath": "cryptography.encryption",
              "type": "select",
              "options": ["1.3.6.1.4.1.188.7.1.1.2"]
            },
            {
              "name": "smimeSymmetricKeySize",
              "dataPath": "cryptography.encryption",
              "type": "select",
              "options": ["0", "4096"]
            },
            // Cryptography Decryption
            {
              "name": "pgpCheckInline",
              "dataPath": "cryptography.decryption",
              "type": "boolean"
            },
            {
              "name": "pgpBinaryRegex",
              "dataPath": "cryptography.decryption",
              "type": "text"
            },
            // Cryptography Validation
            {
              "name": "pgpCheckInline",
              "dataPath": "cryptography.validation",
              "type": "boolean"
            },
          ]
        }
      },
    },
    {
      "name": "Uptrust Keysources",
      "id": "keysources",
      "icon": "key",
      "methods": {
        "getAll": {
          "url": "/uptrust/keysources",
          "dataPath": "data",
          "dataTransform": (value) => {
            // change the "file" property to only contain the file name
            value.forEach((item) => {
              if (item.config && item.config.file) {
                // Handle both Windows and Unix paths
                const fileName = item.config.file.split(/[/\\]/).pop();
                item.config.file = fileName;
              }
            });
            return value;
          },
          "display": {
            "type": "table"
          },
          "fields": [
            {
              "name": "enabled",
              "type": "boolean",
            },
            {
              "name": "id",
              "type": "text",
            },
            {
              "name": "cryptography",
              "type": "text",
            },
            {
              "name": "confidentiality",
              "type": "text",
            },
            {
              "name": "type",
              "type": "text",
            }
          ]
        },
        // ----------------------------
        // Keysource UPDATE
        // ----------------------------
        "put": {
          "url": "/uptrust/keysources/:uuid",
          "fields": [
            {
              "name": "uuid",
              "type": "hidden"
            },
            {
              "name": "priority",
              "type": "hidden",
            },
            // ---- ENABLED ----
            {
              "name": "enabled",
              "type": "boolean",
            },
            // ---- ID ----
            {
              "name": "id",
              "type": "text",
            },
            // ---- CRYPTOGRAPHY ----
            {
              "name": "cryptography",
              "type": "select",
              "options": ["PGP", "SMIME"],
              "onChange": (newValue, fields) => {
                const typeField = fields.find(f => f.originalName === "type");

                // Reset type field
                if (newValue === "SMIME" && (typeField.value === "keyserver" || typeField.value === "globaldirectory")) {
                  typeField.value = "";
                }

                // Adapt type field options
                typeField.options = newValue === "PGP"
                  ? ["keystore", "keyserver", "keybox", "ldap", "globaldirectory"]
                  : ["keystore", "keybox", "ldap"];
              }
            },
            // ---- TYPE ----
            {
              "name": "type",
              "type": "select",
              "options": ["keystore", "keyserver", "keybox", "ldap", "globaldirectory"],
              "onChange": (newValue, fields) => {
                const confidentialityField = fields.find(f => f.originalName === "confidentiality");

                // Reset confidentiality field
                if (newValue !== "keystore") {
                  confidentialityField.value = "public";
                  confidentialityField.options = ["public"];
                } else {
                  confidentialityField.options = ["public", "private"];
                }
              }
            },
            // ---- CONFIDENTIALITY ----
            // private / public (Keystore)
            {
              "name": "confidentiality",
              "type": "select",
              "options": ["public", "private"],
            },
            // ---- CONFIGURATION OBJECT ----
            // Keystore / Keybox
            {
              "name": "file",
              "type": "text",
              "readonly": true,
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && (typeField.value === "keystore" || typeField.value === "keybox");
              },
            },
            {
              "name": "fileUpload",
              "type": "file",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && (typeField.value === "keystore" || typeField.value === "keybox");
              },
            },
            // Keystore / Keybox / Keyserver
            {
              "name": "url",
              "type": "text",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "keystore" || typeField.value === "keybox" || typeField.value === "keyserver";
              },
            },
            // Keystore SMIME/PGP - private 
            {
              "name": "password",
              "type": "password",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                const confidentialityField = fields.find(f => f.originalName === "confidentiality");
                return typeField && typeField.value === "keystore" && confidentialityField && confidentialityField.value === "private";
              }
            },
            // Keystore SMIME
            {
              "name": "type",
              "type": "select",
              "options": ["PKCS7", "PKCS12", "BKS"],
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                const cryptoField = fields.find(f => f.originalName === "cryptography");
                return typeField && typeField.value === "keystore" && cryptoField && cryptoField.value === "SMIME";
              },
            },
            // Keyserver
            {
              "name": "encodeSearchParam",
              "type": "boolean",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "keyserver";
              },
            },
            {
              "name": "timeout",
              "type": "number",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "keyserver";
              },
            },
            // LDAP / GLOBALDIRECTORY
            {
              "name": "hostURL",
              "type": "text",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && (typeField.value === "ldap" || typeField.value === "globaldirectory");
              },
            },
            // LDAP
            {
              "name": "baseDN",
              "type": "text",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "ldap";
              },
            },
            {
              "name": "emailAttribute",
              "type": "text",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "ldap";
              },
            },
            {
              "name": "filter",
              "type": "text",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "ldap";
              },
            },
            {
              "name": "disableTrustCheck",
              "type": "boolean",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "ldap";
              },
            },
            // LDAP / GLOBALDIRECTORY 
            {
              "name": "user",
              "type": "text",
              "dataPath": "config.auth",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && (typeField.value === "ldap" || typeField.value === "globaldirectory");
              },
            },
            {
              "name": "password",
              "type": "password",
              "dataPath": "config.auth",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && (typeField.value === "ldap" || typeField.value === "globaldirectory");
              },
            },
          ]
        },
        "post": {
          "url": "/uptrust/keysources",
          "fields": [
            {
              "name": "uuid",
              "type": "hidden"
            },
            {
              "name": "priority",
              "type": "hidden",
            },
            // ---- ENABLED ----
            {
              "name": "enabled",
              "type": "boolean",
              "value": true,
            },
            // ---- ID ----
            {
              "name": "id",
              "type": "text",
            },
            // ---- CRYPTOGRAPHY ----
            {
              "name": "cryptography",
              "type": "select",
              "options": ["PGP", "SMIME"],
              "onChange": (newValue, fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                // Reset type field
                if (newValue === "SMIME" && (typeField.value === "keyserver" || typeField.value === "globaldirectory")) {
                  typeField.value = "";
                }

                // Adapt type field options
                typeField.options = newValue === "PGP"
                  ? ["keystore", "keyserver", "keybox", "ldap", "globaldirectory"]
                  : ["keystore", "keybox", "ldap"];
              }
            },
            // ---- TYPE ----
            {
              "name": "type",
              "type": "select",
              "options": ["keystore", "keyserver", "keybox", "ldap", "globaldirectory"],
              "onChange": (newValue, fields) => {
                const confidentialityField = fields.find(f => f.originalName === "confidentiality");

                // Reset confidentiality field
                if (newValue !== "keystore") {
                  confidentialityField.value = "public";
                  confidentialityField.options = ["public"];
                } else {
                  confidentialityField.options = ["public", "private"];
                }
              }
            },
            // ---- CONFIDENTIALITY ----
            // private / public (Keystore)
            {
              "name": "confidentiality",
              "type": "select",
              "options": ["public", "private"],
            },
            // ---- CONFIGURATION OBJECT ----
            // Keystore / Keybox
            {
              "name": "fileUpload",
              "type": "file",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && (typeField.value === "keystore" || typeField.value === "keybox");
              },
            },
            // Keystore / Keybox / Keyserver
            {
              "name": "url",
              "type": "text",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "keystore" || typeField.value === "keybox" || typeField.value === "keyserver";
              },
            },
            // Keystore SMIME/PGP - private 
            {
              "name": "password",
              "type": "password",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                const confidentialityField = fields.find(f => f.originalName === "confidentiality");
                return (typeField && typeField.value === "keystore") &&
                  (confidentialityField && confidentialityField.value === "private");
              },
            },
            // Keystore SMIME
            {
              "name": "type",
              "type": "select",
              "options": ["PKCS7", "PKCS12", "BKS"],
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                const cryptoField = fields.find(f => f.originalName === "cryptography");
                return typeField && typeField.value === "keystore" && cryptoField && cryptoField.value === "SMIME";
              },
            },
            // Keyserver
            {
              "name": "encodeSearchParam",
              "type": "boolean",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "keyserver";
              },
            },
            {
              "name": "timeout",
              "type": "number",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "keyserver";
              },
            },
            // LDAP / GLOBALDIRECTORY
            {
              "name": "hostURL",
              "type": "text",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && (typeField.value === "ldap" || typeField.value === "globaldirectory");
              },
            },
            // LDAP
            {
              "name": "baseDN",
              "type": "text",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "ldap";
              },
            },
            {
              "name": "emailAttribute",
              "type": "text",
              "value": "mail",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "ldap";
              },
            },
            {
              "name": "filter",
              "type": "text",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "ldap";
              },
            },
            {
              "name": "disableTrustCheck",
              "type": "boolean",
              "dataPath": "config",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && typeField.value === "ldap";
              },
            },
            // LDAP / GLOBALDIRECTORY 
            {
              "name": "user",
              "type": "text",
              "dataPath": "config.auth",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && (typeField.value === "ldap" || typeField.value === "globaldirectory");
              },
            },
            {
              "name": "password",
              "type": "password",
              "dataPath": "config.auth",
              "showFieldWhen": (fields) => {
                const typeField = fields.find(f => f.originalName === "type");
                return typeField && (typeField.value === "ldap" || typeField.value === "globaldirectory");
              }
            },
          ]
        },
        "delete": {
          "url": "/uptrust/keysources/:uuid"
        }
      },
      "customActions": [
        {
          "name": "Move down",
          "url": "/uptrust/keysources/:uuid/movedown",
          "actualMethod": "post",
          "icon": "arrow-down",
          "fields": [],
          "suppressDialog": true,
          "requireConfirmation": false
        },
        {
          "name": "Move up",
          "url": "/uptrust/keysources/:uuid/moveup",
          "actualMethod": "post",
          "icon": "arrow-up",
          "fields": [],
          "suppressDialog": true,
          "requireConfirmation": false
        },
      ]
    },
    {
      "name": "Uptrust Domainkeys",
      "id": "domainkeys",
      "icon": "globe",
      "methods": {
        "getAll": {
          "url": "/uptrust/domainkeys",
          "dataPath": "data",
          "display": {
            "type": "table"
          },
          "fields": [
            {
              "name": "email",
              "type": "text",
            },
            {
              "name": "type",
              "type": "text",
            }
          ]
        },
        "put": {
          "url": "/uptrust/domainkeys/:uuid",
          "fields": [
            {
              "name": "email",
              "type": "text",
            },
            {
              "name": "type",
              "type": "select",
              "options": ["PGP", "SMIME"]
            }
          ]
        },
        "post": {
          "url": "/uptrust/domainkeys",
          "fields": [
            {
              "name": "email",
              "type": "text",
            },
            {
              "name": "type",
              "type": "select",
              "options": ["PGP", "SMIME"],
            }
          ]
        },
        "delete": {
          "url": "/uptrust/domainkeys/:uuid"
        }
      },
    },
    {
      "name": "Mailserver Settings",
      "id": "mailserver",
      "icon": "envelope",
      "singleItemPage": true,
      "methods": {
        "getAll": {
          "url": "/uptrust/smtp-imap-config",
          "dataPath": "data",
          "display": {
            "type": "cards"
          },
          "fields": [
            {
              "name": "smtpHost",
              "type": "text"
            },
            {
              "name": "smtpPort",
              "type": "text"
            },
            {
              "name": "smtpTls",
              "type": "text"
            },
            {
              "name": "imapHost",
              "type": "text"
            },
            {
              "name": "imapPort",
              "type": "text"
            },
            {
              "name": "imapTls",
              "type": "text"
            }
          ]
        },
        "put": {
          "url": "/uptrust/smtp-imap-config",
          "fields": [
            {
              "name": "smtpHost",
              "type": "text"
            },
            {
              "name": "smtpPort",
              "type": "text"
            },
            {
              "name": "smtpTls",
              "type": "select",
              "options": ["enabled", "disabled", "starttls"]
            },
            {
              "name": "imapHost",
              "type": "text"
            },
            {
              "name": "imapPort",
              "type": "text"
            },
            {
              "name": "imapTls",
              "type": "select",
              "options": ["enabled", "disabled", "starttls"]
            }
          ]
        },
      }
    },
    {
      "name": "License",
      "id": "license",
      "icon": "certificate",
      "singleItemPage": true,
      "methods": {
        "getAll": {
          "url": "/uptrust/license",
          "dataPath": "data",
          "display": {
            "type": "cards"
          },
          "fields": [
            // Decoded License Information
            {
              "dataPath": "decodedLicense",
              "name": "licensed_to",
              "type": "text",
            },
            {
              "dataPath": "decodedLicense",
              "name": "licensed_for",
              "type": "text",
            },
            {
              "dataPath": "decodedLicense",
              "name": "valid_until",
              "type": "text",
            },
            {
              "dataPath": "decodedLicense",
              "name": "licenseId",
              "type": "text",
            }
          ]
        },
        "put": {
          "url": "/uptrust/license",
          "fields": [
            {
              "dataPath": "rawLicense",
              "name": "licenseRaw",
              "type": "long-text",
              "required": true,
            },
            {
              "dataPath": "rawLicense",
              "name": "licenseFormat",
              "type": "hidden",
              "value": "BASE64"
            }
          ]
        }
      }
    }
  ]
}