# Uptrust

## Quickstart Guide for running Uptrust Gateway with Configuration UI

1. **Prepare Uptrust Gateway**<br>
    Prepare the initial configuration files for uptrust in the `gateway/conf` directory.

2. **Start Uptrust Configuration Server**<br>
    Start the config server in the `app` directory.
    ```
    cd app
    java -jar config.server.jar
    ```

    By default, the server will start on port 8080. You can change the port by adding the --server.port argument.

    ```
    java -jar config.server-<version>.jar --server.port=8081
    ```
    
    The Configuration Server will automatically also start the Uptrust Gateway.


3. **Access Configuration GUI**<br>
Access the configuration GUI at `http://localhost:8080`.<br>
You will be asked to login with the default credentials `admin` and `uptrust`.<br>
Please change the password after the first login.<br>

## Reset Database from XML Files

If you want to reset the configuration database from the local XML files, you can use the following command:
```
java -jar config.server.jar --initdb
```

## Configuration

The following properties can be configured through environment variables.
If not set, the default values will be used. 

| Environment Variable | Default | Description |
|---------------------|---------|-------------|
 `UPTRUST_KEYSOURCE_UPLOAD_PATH` | `uploaded/` | Directory where uploaded key files will be stored. Use absolute paths (e.g., `/var/uptrust/keys/`) or relative paths (relative to `/app` directory) |
| `UPTRUST_CONFIG_PATH` | `../gateway/conf` | Path to the directory containing Uptrust configuration files. Use absolute paths (e.g., `/var/uptrust/conf/`) or relative paths (relative to `/app` directory) |
| `UPTRUST_GATEWAY_PATH` | `../gateway/james-server-memory-app.jar` | Path to the Uptrust server JAR file. Use absolute paths (e.g., `/var/uptrust/gateway/james-server-memory-app.jar`) or relative paths (relative to `/app` directory) |
| `UPTRUST_LOGS_DIR` | `logs` | Directory where all log files will be stored. Use absolute paths or paths relative to the application directories |
| `UPTRUST_LOG_LEVEL` | `INFO` | Log level for the Uptrust application. Can be set to DEBUG, INFO, WARN, or ERROR. |
| `JAMES_HEALTHCHECK_URL` | `http://localhost:8080/healthcheck` | URL for the health check endpoint of the Uptrust server. It refers to the James Webadmin API. This is used from the admin server to check if uptrust is running and healthy. |