/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.util;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;

public class UriBuilder {
    private final URIBuilder builder;

    private UriBuilder(URIBuilder builder) {
        this.builder = Preconditions.checkNotNull(builder);
    }

    public static UriBuilder fromUri(URI uri) {
        return new UriBuilder(new URIBuilder(Preconditions.checkNotNull(uri)));
    }

    public static UriBuilder fromUri(String uri) {
        try {
            return new UriBuilder(new URIBuilder(Preconditions.checkNotNull(uri)));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public URI build() {
        try {
            return this.builder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public UriBuilder host(String host) {
        this.builder.setHost(Preconditions.checkNotNull(host));
        return this;
    }

    public UriBuilder path(String addPath) {
        Preconditions.checkNotNull(addPath);
        String old = this.builder.getPath();
        if (!old.endsWith("/") && !addPath.startsWith("/")) {
            old = old + "/";
        }
        this.builder.setPath(old + addPath);
        return this;
    }

    public UriBuilder queryParam(String name, Object ... value) {
        for (Object v : Preconditions.checkNotNull(value)) {
            this.builder.addParameter(Preconditions.checkNotNull(name), String.valueOf(Preconditions.checkNotNull(v)));
        }
        return this;
    }
}

