/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.atlassian.marketplace.appupdater;

import com.atlassian.marketplace.client.model.HtmlString;
import net.savignano.atlassian.marketplace.appupdater.AppVersion;
import net.savignano.atlassian.marketplace.appupdater.VersionProperties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.joda.time.LocalDate;

public class Main {
    public static void main(String[] args) {
        AppVersion appVersion;
        String appKey;
        Options options = new Options();
        Option config = new Option("c", "configfile", true, "config file path");
        config.setRequired(true);
        options.addOption(config);
        Option update = new Option("u", "update", false, "perform version update");
        update.setRequired(false);
        options.addOption(update);
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("utility-name", options);
            Main.fail("Invalid or missing command line parameters");
        }
        String configFilePath = cmd.getOptionValue("configfile");
        boolean doUpdate = cmd.getOptionValue("update") != null;
        System.out.println("configfile=" + configFilePath + " update=" + doUpdate);
        VersionProperties properties = new VersionProperties();
        if (!properties.loadProperties(configFilePath)) {
            Main.fail("Error: Failed to load properties file " + configFilePath);
        }
        if ((appKey = properties.getAppKey()) == null) {
            Main.fail("Required property 'app.key' not found");
        }
        if (!(appVersion = new AppVersion(appKey)).createFromLatest()) {
            Main.fail("Failed to get latest version of " + appKey);
        }
        String artifactFile = properties.getArtifactFile();
        String artifactUrl = properties.getArtifactUrl();
        String version = properties.getReleaseVersion();
        LocalDate releaseDate = properties.getReleaseDate();
        String releaseSummary = properties.getReleaseSummary();
        HtmlString releaseNotes = properties.getReleaseNotes();
        if (artifactFile != null) {
            appVersion.setArtifactFromFile(artifactFile);
        } else if (artifactUrl != null) {
            appVersion.setArtifactFromUrl(artifactUrl);
        } else {
            Main.fail("Required property 'artifact.file' or 'artifact.url' not found");
        }
        appVersion.setVersion(version);
        appVersion.setReleaseInfo(releaseDate, releaseSummary, releaseNotes);
        if (!doUpdate) {
            System.out.println("No update requested - exiting");
            System.exit(0);
        }
        System.out.println("Exiting, not creating a new version");
        System.exit(0);
        if (!appVersion.saveNewVersion()) {
            Main.fail("Failed to create new version " + version + " of " + appKey);
        }
    }

    public static void fail(String message) {
        System.out.println("Error: " + message);
        System.exit(1);
    }
}

