/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.atlassian.marketplace.appupdater;

import com.atlassian.marketplace.client.MarketplaceClient;
import com.atlassian.marketplace.client.MarketplaceClientFactory;
import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.api.AddonQuery;
import com.atlassian.marketplace.client.api.AddonVersionExternalLinkType;
import com.atlassian.marketplace.client.api.ArtifactId;
import com.atlassian.marketplace.client.http.HttpConfiguration;
import com.atlassian.marketplace.client.model.Addon;
import com.atlassian.marketplace.client.model.AddonVersion;
import com.atlassian.marketplace.client.model.AddonVersionStatus;
import com.atlassian.marketplace.client.model.Highlight;
import com.atlassian.marketplace.client.model.HtmlString;
import com.atlassian.marketplace.client.model.ModelBuilders;
import com.atlassian.marketplace.client.model.Screenshot;
import com.atlassian.marketplace.client.util.EntityFunctions;
import io.atlassian.fugue.Option;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.Optional;
import org.joda.time.LocalDate;

public class AppVersion {
    private String addonKey;
    private MarketplaceClient client = AppVersion.setupConnection();
    private ModelBuilders.AddonVersionBuilder newVersionBuilder;

    public AppVersion(String appKey) {
        this.addonKey = new String(appKey);
    }

    public boolean createFromLatest() {
        return this.createFromLatest(false);
    }

    public boolean createFromLatest(boolean includePrivate) {
        Addon addon;
        try {
            AddonQuery aQuery = AddonQuery.builder().includePrivate(includePrivate).withVersion(true).build();
            Optional<Addon> optionalAddon = this.client.addons().safeGetByKey(this.addonKey, aQuery);
            if (!optionalAddon.isPresent()) {
                System.out.println("Couldn't find app with key " + this.addonKey);
                return false;
            }
            addon = optionalAddon.get();
        }
        catch (MpacException e) {
            e.printStackTrace();
            return false;
        }
        System.out.println("App name: " + addon.getName() + "\nTag line: " + (String)addon.getTagLine().get() + "\nSummary: " + (String)addon.getSummary().get());
        System.out.println("Retrieving last addon version, " + (includePrivate ? "including" : "excluding") + " private versions");
        AddonVersion addonVersion = (AddonVersion)addon.getVersion().get();
        System.out.println("Status: " + addonVersion.getStatus());
        System.out.println("Release version: " + (String)addonVersion.getName().get() + "\nBuild number: " + addonVersion.getBuildNumber() + "\nDC build number: " + addon.getDataCenterBuildNumber() + "\nRelease date: " + addonVersion.getReleaseDate() + "\nRelease summary: " + (String)addonVersion.getReleaseSummary().get() + "\nMore details: " + ((HtmlString)addonVersion.getMoreDetails().get()).getHtml() + "\nRelease notes: " + ((HtmlString)addonVersion.getReleaseNotes().get()).getHtml() + "\nPayment model: " + addonVersion.getPaymentModel() + "\nLicense type: " + addonVersion.getLicenseType().flatMap(EntityFunctions.selfUri()));
        int i = 1;
        for (Highlight highlight : addonVersion.getHighlights()) {
            System.out.println("Highlight " + i++ + "\nTitle: " + highlight.getTitle() + "\nSummary: " + highlight.getBody().getHtml() + "\nCaption: " + highlight.getExplanation().getOrNull());
        }
        i = 1;
        for (Screenshot screenshot : addonVersion.getScreenshots()) {
            System.out.println("Screenshot " + i++ + "\nCaption: " + (String)screenshot.getCaption().get());
        }
        this.newVersionBuilder = ModelBuilders.addonVersion().status(AddonVersionStatus.PRIVATE).paymentModel(addonVersion.getPaymentModel()).licenseType(addonVersion.getLicenseType()).releasedBy(addonVersion.getReleasedBy()).highlights((Iterable)addonVersion.getHighlightsIfSpecified().get()).screenshots((Iterable)addonVersion.getScreenshotsIfSpecified().get()).youtubeId(addonVersion.getYoutubeId()).compatibilities((Iterable)addonVersion.getCompatibilitiesIfSpecified().get()).beta(addonVersion.isBeta()).supported(addonVersion.isSupported()).staticAddon(addonVersion.isStatic()).deployable(addonVersion.isDeployable()).releaseSummary(addonVersion.getReleaseSummary()).moreDetails(addonVersion.getMoreDetails());
        for (Iterator<Object> iterator : AddonVersionExternalLinkType.values()) {
            for (URI u : addonVersion.getExternalLinkUri((AddonVersionExternalLinkType)((Object)iterator))) {
                this.newVersionBuilder.externalLinkUri((AddonVersionExternalLinkType)((Object)iterator), Option.some(u));
            }
        }
        return true;
    }

    public boolean setArtifactFromFile(String artifactFile) {
        ArtifactId artifactId;
        File file = new File(artifactFile);
        try {
            artifactId = this.client.assets().uploadAddonArtifact(file);
        }
        catch (MpacException e) {
            e.printStackTrace();
            System.out.println("Failed to upload artifact file " + artifactFile);
            return false;
        }
        this.newVersionBuilder.artifact(Option.some(artifactId));
        return true;
    }

    public boolean setArtifactFromUrl(String artifactUrl) {
        ArtifactId artifactId = ArtifactId.fromUri(URI.create(artifactUrl));
        this.newVersionBuilder.artifact(Option.some(artifactId));
        return true;
    }

    public boolean setVersion(String version, String hosting) {
        long buildNumber = this.deriveBuildNumberFromVersion(version) * 100L + 10L;
        long dcBuildNumber = buildNumber + 1L;
        if (!hosting.equals("both")) {
            dcBuildNumber = 0L;
        }
        System.out.println("Setting version: " + version + " for " + hosting + ", Server build number: " + buildNumber + ", Data Center build number: " + (dcBuildNumber == 0L ? "none" : Long.valueOf(dcBuildNumber)));
        this.newVersionBuilder.name(version).buildNumber(buildNumber);
        if (dcBuildNumber != 0L) {
            this.newVersionBuilder.dataCenterBuildNumber(dcBuildNumber);
        }
        return true;
    }

    public boolean setReleaseInfo(LocalDate releaseDate, String releaseSummary, HtmlString releaseNotes) {
        this.newVersionBuilder.releaseSummary(Option.option(releaseSummary)).releaseNotes(Option.option(releaseNotes)).releaseDate(releaseDate);
        return true;
    }

    public boolean saveNewVersion() {
        AddonVersion newAddonVersion;
        try {
            newAddonVersion = (AddonVersion)this.newVersionBuilder.build();
        }
        catch (ModelBuilders.InvalidModelException e1) {
            e1.printStackTrace();
            return false;
        }
        try {
            this.client.addons().createVersion(this.addonKey, newAddonVersion);
        }
        catch (MpacException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private long deriveBuildNumberFromVersion(String version) {
        long buildNumber = 0L;
        for (String part : version.split("\\.", 3)) {
            buildNumber = buildNumber * 1000L + (long)Integer.parseInt(part);
        }
        return buildNumber;
    }

    private static MarketplaceClient setupConnection() {
        HttpConfiguration config = HttpConfiguration.builder().connectTimeoutMillis(60000).readTimeoutMillis(60000).credentials(Option.some(new HttpConfiguration.Credentials("atlassian.robot@savignano.net", "PuDb7W8dxKC4IgKAOM2l1F8F"))).build();
        MarketplaceClient client = MarketplaceClientFactory.createMarketplaceClient(config);
        return client;
    }
}

