/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.atlassian.marketplace.appupdater;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.atlassian.marketplace.client.model.HtmlString;
import net.savignano.atlassian.marketplace.appupdater.AppVersion;
import net.savignano.atlassian.marketplace.appupdater.VersionProperties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.joda.time.LocalDate;
import org.slf4j.LoggerFactory;

public class Main {
    public static void main(String[] args) {
        String appKey;
        AppVersion appVersion;
        Options options = new Options();
        Option config = new Option("c", "configfile", true, "configuration properties file path");
        config.setRequired(true);
        options.addOption(config);
        Option update = new Option("u", "update", false, "perform version update");
        update.setRequired(false);
        options.addOption(update);
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("java -jar app-updater.jar", options);
            Main.fail("Invalid or missing command line parameters");
        }
        String configFilePath = cmd.getOptionValue("configfile");
        boolean doUpdate = cmd.hasOption("update");
        System.out.println("configfile=" + configFilePath + " update=" + doUpdate);
        VersionProperties properties = new VersionProperties();
        if (!properties.loadProperties(configFilePath)) {
            Main.fail("Error: Failed to load properties file " + configFilePath);
        }
        if (!(appVersion = new AppVersion(appKey = properties.getAppKey())).createFromLatest()) {
            Main.fail("Failed to get latest version of " + appKey);
        }
        String artifactFile = properties.getArtifactFile();
        String artifactUrl = properties.getArtifactUrl();
        String releaseVersion = properties.getReleaseVersion();
        LocalDate releaseDate = properties.getReleaseDate();
        String releaseSummary = properties.getReleaseSummary();
        HtmlString releaseNotes = properties.getReleaseNotes();
        appVersion.setVersion(releaseVersion, properties.getHosting());
        appVersion.setReleaseInfo(releaseDate, releaseSummary, releaseNotes);
        if (!doUpdate) {
            System.out.println("No update requested - exiting");
            System.exit(0);
        }
        if (artifactFile != null) {
            if (!appVersion.setArtifactFromFile(artifactFile)) {
                Main.fail("Failed to upload specified artifact file from " + artifactFile);
            }
        } else if (artifactUrl != null) {
            appVersion.setArtifactFromUrl(artifactUrl);
        } else {
            Main.fail("Required property 'artifact.file' or 'artifact.url' not found");
        }
        Main.enableExtraLogging("org.apache.http.wire", true);
        Main.enableExtraLogging("com.atlassian.marketplace.client", false);
        if (!appVersion.saveNewVersion()) {
            Main.fail("Failed to create new version " + releaseVersion + " of " + appKey);
        }
    }

    public static void fail(String message) {
        System.out.println("Error: " + message);
        System.exit(1);
    }

    protected static void enableExtraLogging(String packageName, boolean debug) {
        Logger logger = (Logger)LoggerFactory.getLogger(packageName);
        logger.setLevel(debug ? Level.DEBUG : Level.INFO);
    }
}

