/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.atlassian.marketplace.appupdater;

import com.atlassian.marketplace.client.model.HtmlString;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;

public class VersionProperties {
    Properties properties;
    File propertiesFolder;

    public String getAppKey() {
        return this.properties.getProperty("app.key");
    }

    public String getArtifactFile() {
        String filename = this.properties.getProperty("artifact.file");
        if (filename != null) {
            if (filename.startsWith("~" + File.separator)) {
                filename = System.getProperty("user.home") + filename.substring(1);
            } else if (filename.startsWith("." + File.separator)) {
                filename = this.propertiesFolder + filename.substring(1);
            }
        }
        return filename;
    }

    public String getHosting() {
        String hosting = this.properties.getProperty("app.hosting").toLowerCase();
        if (!hosting.equals("dc_only") && !hosting.equals("server_only")) {
            hosting = "both";
        }
        return hosting;
    }

    public String getArtifactUrl() {
        return this.properties.getProperty("artifact.url");
    }

    public String getReleaseVersion() {
        return this.properties.getProperty("release.version");
    }

    public String getReleaseSummary() {
        return this.properties.getProperty("release.summary");
    }

    public HtmlString getReleaseNotes() {
        String releaseNotes = this.properties.getProperty("release.notes");
        if (releaseNotes == null) {
            String filename = this.properties.getProperty("release.notes.file");
            if (filename == null) {
                return null;
            }
            try {
                filename = new File(this.propertiesFolder, filename).getCanonicalPath();
                releaseNotes = new String(Files.readAllBytes(Paths.get(filename, new String[0])));
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("Failed to read release.notes.file " + filename);
                return null;
            }
        }
        return HtmlString.html(releaseNotes);
    }

    public LocalDate getReleaseDate() {
        String dateProperty = this.properties.getProperty("release.date");
        if (dateProperty == null) {
            return new DateTime().toLocalDate();
        }
        return DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(dateProperty).toLocalDate();
    }

    public String getUserid() {
        return this.properties.getProperty("authentication.userid");
    }

    public String getToken() {
        return this.properties.getProperty("authentication.token");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadProperties(String pathAndFilename) {
        this.properties = new Properties();
        InputStreamReader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(pathAndFilename), "UTF-8");
            this.properties.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.propertiesFolder = new File(new File(pathAndFilename).getParent());
        return this.checkProperties();
    }

    private boolean checkProperties() {
        int errors = 0;
        if (this.getAppKey() == null) {
            System.out.println("Required property 'app.key' not found");
            ++errors;
        }
        if (this.getArtifactFile() == null && this.getArtifactUrl() == null) {
            System.out.println("Required property 'app.artifact.file or .url' not found");
            ++errors;
        }
        return errors == 0;
    }
}

